/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.certpath.CertPath;
import com.dstc.security.certpath.CertPathBuilder;
import com.dstc.security.certpath.CertPathException;
import com.dstc.security.certpath.X509CertSelector;
import com.dstc.security.cms.Attribute;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.DigestsInputStream;
import com.dstc.security.cms.Factory;
import com.dstc.security.cms.IssuerAndSerialNumber;
import com.dstc.security.cms.IssuerAndSerialNumberImpl;
import com.dstc.security.cms.SignatureInputStream;
import com.dstc.security.cms.SignedAttributes;
import com.dstc.security.cms.SignerIdentifier;
import com.dstc.security.cms.SignerInfo;
import com.dstc.security.cms.SubjectKeyIdentifier;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;

class Signer
implements SignerInfo {
    private Asn1 asn1 = null;
    private CertPathBuilder builder = null;
    private Vector certs = null;
    private DigestsInputStream dis = null;
    private X509Certificate signerCert = null;
    private Vector signedAttributes = null;
    private Vector unsignedAttributes = null;
    private String digestAlg = "SHA";
    private String sigAlg = null;
    private byte[] toBeSigned = null;
    private byte[] signature = null;
    private String provider = null;
    private byte[] digest = null;
    private Signature sig = null;
    private int version = 1;
    private SignedAttributes signedAtts;
    private SignedAttributes unsignedAtts;
    private SignerIdentifier signerId;
    private boolean verified = false;

    Signer(Asn1 asn1, Vector vector, Vector vector2, DigestsInputStream digestsInputStream) throws CMSException, Asn1Exception, IOException, CertificateException, CertPathException {
        this.certs = vector;
        this.builder = new CertPathBuilder();
        this.builder.setTrustedCerts(vector2);
        this.dis = digestsInputStream;
        this.decode(asn1, vector, vector2);
        this.verifySigner();
    }

    Signer(PrivateKey privateKey, X509Certificate x509Certificate, String string, Asn1 asn1) throws CMSException {
        try {
            String string2;
            this.asn1 = new Sequence();
            this.asn1.add(new Integer(this.version));
            this.asn1.add(new IssuerAndSerialNumberImpl(x509Certificate).getAsn1());
            this.digestAlg = string;
            this.asn1.add(new AlgorithmId(OID.getAlgOid(string)).getAsn1());
            if (asn1 != null) {
                this.asn1.add(asn1);
            }
            if ((string2 = privateKey.getAlgorithm()).equals("RSA")) {
                this.asn1.add(new AlgorithmId("1.2.840.113549.1.1.1").getAsn1());
            } else if (string2.equals("DSA")) {
                this.asn1.add(new AlgorithmId("1.2.840.10040.4.3").getAsn1());
            }
            if (asn1 == null) {
                this.sig = Signature.getInstance("Raw" + string2);
            } else if (string.equals("MD5")) {
                this.sig = Signature.getInstance("MD5with" + string2);
            } else if (string.startsWith("SHA")) {
                this.sig = Signature.getInstance("SHA1with" + string2);
            } else {
                throw new CMSException("Unsupported digest algorithm: " + string + " in CMS");
            }
            this.sig.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    private void checkDigestBytes(byte[] byArray) throws IOException, CMSException {
        if (this.signedAttributes == null) {
            return;
        }
        Iterator iterator = ((AbstractList)this.signedAttributes).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getOid().equals("1.2.840.113549.1.9.4")) continue;
            if (!Arrays.equals(byArray, attribute.getEncodedValues())) {
                throw new CMSException("Digest mismatch");
            }
            return;
        }
        throw new CMSException("Cannot find MessageDigest attribute amongst signed attributes");
    }

    void computeSignature(byte[] byArray) throws CMSException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SignatureInputStream signatureInputStream = new SignatureInputStream(byteArrayInputStream, this.sig, this.digestAlg);
            byte[] byArray2 = new byte[150];
            int n = 0;
            int n2 = 0;
            while ((n = signatureInputStream.read(byArray2, n2, byArray2.length - n2)) != -1) {
                n2 += n;
            }
            this.asn1.add(new OctetString(byArray2, 0, n2));
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    private void decode(Asn1 asn1, Vector vector, Vector vector2) throws CMSException, Asn1Exception, IOException, CertificateException, CertPathException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.version = ((Integer)iterator.next()).getInt();
        Asn1 asn12 = (Asn1)iterator.next();
        this.signerId = Factory.getSignerIdentifier(asn12);
        this.digestAlg = OID.getAlgName(new AlgorithmId((Asn1)iterator.next()).getOid());
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.signedAtts = new SignedAttributes(asn12);
            this.signedAttributes = this.signedAtts.getAttributes();
            asn12 = (Asn1)iterator.next();
        }
        this.sigAlg = OID.getAlgName(new AlgorithmId(asn12).getOid());
        this.sigAlg = this.sigAlg.equals("RSA") ? String.valueOf(this.digestAlg) + "/RSA" : "DSA";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((OctetString)iterator.next()).writeValue(byteArrayOutputStream);
        this.signature = byteArrayOutputStream.toByteArray();
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        if (asn12 == null) {
            return;
        }
        if (asn12.getTagNumber() == 1) {
            this.unsignedAtts = new SignedAttributes(asn12);
            this.unsignedAttributes = this.unsignedAtts.getAttributes();
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public int getCMSVersion() {
        return this.version;
    }

    public String getDigestAlgorithm() {
        return this.digestAlg;
    }

    public String getSignatureAlgorithm() {
        return this.sigAlg;
    }

    public byte[] getSignatureValue() {
        return this.signature;
    }

    public Attribute[] getSignedAttributes() {
        if (this.signedAttributes == null) {
            return null;
        }
        Attribute[] attributeArray = new Attribute[this.signedAttributes.size()];
        this.signedAttributes.toArray(attributeArray);
        return attributeArray;
    }

    private X509Certificate getSignerCert(SignerIdentifier signerIdentifier) throws CertificateException, CertPathException, CMSException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        if (signerIdentifier instanceof IssuerAndSerialNumber) {
            x509CertSelector.setIssuerDN(((IssuerAndSerialNumber)signerIdentifier).getIssuer());
            x509CertSelector.setSerialNumber(((IssuerAndSerialNumber)signerIdentifier).getSerialNumber());
        } else if (signerIdentifier instanceof SubjectKeyIdentifier) {
            x509CertSelector.setSubjectKeyIdentifier(((SubjectKeyIdentifier)signerIdentifier).getId());
        } else {
            throw new CMSException("Unsupported signerIdentifier: " + signerIdentifier);
        }
        CertPath certPath = this.builder.build(this.certs, x509CertSelector);
        X509Certificate x509Certificate = certPath.getPath()[0];
        return x509Certificate;
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCert;
    }

    public SignerIdentifier getSignerIdentifier() {
        return this.signerId;
    }

    public Attribute[] getUnsignedAttributes() {
        if (this.unsignedAttributes == null) {
            return null;
        }
        Attribute[] attributeArray = new Attribute[this.unsignedAttributes.size()];
        this.unsignedAttributes.toArray(attributeArray);
        return attributeArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("SignerInfo");
        if (this.verified) {
            stringBuffer.append(" [Signature Verified]");
        }
        stringBuffer.append("\n[");
        stringBuffer.append("\n  Version: ").append(this.version);
        stringBuffer.append("\n  Message Digest algo: ").append(this.getDigestAlgorithm());
        stringBuffer.append("\n  Signature algo: ").append(this.getSignatureAlgorithm());
        stringBuffer.append("\n  SignerIdentifier:");
        StringTokenizer stringTokenizer = new StringTokenizer(this.signerId.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\n").append("    ").append(stringTokenizer.nextToken());
        }
        Attribute[] attributeArray = this.getSignedAttributes();
        if (attributeArray != null) {
            stringBuffer.append("\n  Signed attributes:");
            n = 0;
            while (n < attributeArray.length) {
                stringBuffer.append("\n    ").append(attributeArray[n]);
                ++n;
            }
        }
        if ((attributeArray = this.getUnsignedAttributes()) != null) {
            stringBuffer.append("\n  Unsigned attributes:");
            n = 0;
            while (n < attributeArray.length) {
                String string = OID.getAlgName(attributeArray[n].getOid());
                if (string != null) {
                    stringBuffer.append("\n    ").append(string);
                } else {
                    stringBuffer.append("\n    ").append(attributeArray[n]);
                }
                ++n;
            }
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public void verifySignature(byte[] byArray) throws CMSException {
        try {
            boolean bl = false;
            if (this.signedAtts != null) {
                this.sig = Signature.getInstance(this.sigAlg);
                this.sig.initVerify(this.signerCert.getPublicKey());
                this.toBeSigned = this.signedAtts.getAsn1().getEncoded();
                this.sig.update(this.toBeSigned);
                bl = this.sig.verify(this.signature);
            } else if (this.sigAlg.equals("DSA")) {
                this.sig = Signature.getInstance("RawDSA");
                this.sig.initVerify(this.signerCert.getPublicKey());
                this.sig.update(byArray);
                bl = this.sig.verify(this.signature);
            } else {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, this.signerCert.getPublicKey());
                byte[] byArray2 = cipher.doFinal(this.signature);
                Asn1 asn1 = Asn1.getAsn1(byArray2);
                Iterator iterator = asn1.components();
                AlgorithmId algorithmId = new AlgorithmId((Asn1)iterator.next());
                byte[] byArray3 = ((OctetString)iterator.next()).getBytes();
                bl = Arrays.equals(byArray3, byArray);
            }
            if (!bl) {
                throw new CMSException("Bad signature");
            }
            this.verified = true;
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    void verifySigner() throws CMSException, IOException, CertificateException, CertPathException {
        this.signerCert = this.getSignerCert(this.signerId);
        this.digest = this.dis.getDigest(this.digestAlg);
        if (this.digest == null) {
            throw new CMSException("Badly formed SignedData: Incomplete list of digest algorithms");
        }
        this.checkDigestBytes(this.digest);
        this.verifySignature(this.digest);
    }
}

