/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Set;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.atts.SigningTime;
import java.util.Date;
import java.util.Iterator;

final class SigningTimeImpl
extends AttributeImpl
implements SigningTime {
    private Date time = null;

    SigningTimeImpl() {
        super("1.2.840.113549.1.9.5", new UTCTime(new Date()));
    }

    SigningTimeImpl(UTCTime uTCTime) {
        super("1.2.840.113549.1.9.5", uTCTime);
    }

    SigningTimeImpl(String string, Set set) throws CMSException {
        this.type = string;
        this.values = set;
        Iterator iterator = set.components();
        Asn1 asn1 = (Asn1)iterator.next();
        if (asn1 == null) {
            throw new CMSException("Signing time cannot be empty");
        }
        if (!(asn1 instanceof UTCTime)) {
            throw new CMSException("Badly encoded signing time");
        }
        this.time = ((UTCTime)asn1).getDate();
    }

    public Date getTime() {
        return this.time;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Signing time: ").append(this.time);
        return stringBuffer.toString();
    }
}

