/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.cms.SubjectKeyIdentifier;
import java.security.cert.X509Certificate;
import java.util.Arrays;

final class SubjectKeyIdentifierImpl
extends SubjectKeyIdentifier {
    private Asn1 asn1 = null;
    private byte[] sid;

    SubjectKeyIdentifierImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        this.sid = ((OctetString)asn1).getBytes();
    }

    SubjectKeyIdentifierImpl(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.14");
        if (byArray != null) {
            this.sid = new byte[byArray.length - 4];
            System.arraycopy(byArray, 4, this.sid, 0, this.sid.length);
            this.asn1 = new OctetString(this.sid);
        }
    }

    SubjectKeyIdentifierImpl(byte[] byArray) {
        this.sid = byArray;
        this.asn1 = new OctetString(byArray);
    }

    public boolean equals(Object object) {
        if (object instanceof SubjectKeyIdentifier) {
            byte[] byArray = ((SubjectKeyIdentifier)object).getId();
            if (this.sid == null || byArray == null) {
                return false;
            }
            return Arrays.equals(this.sid, byArray);
        }
        return false;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getId() {
        return this.sid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SubjectKeyIdentifier: ");
        int n = 0;
        while (n < this.sid.length) {
            stringBuffer.append(String.valueOf(Integer.toHexString(this.sid[n] & 0xFF)) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

