/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.crypto;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Integer;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.KeyAgreeRecipientInfo;
import com.dstc.security.cms.KeyTransRecipientInfo;
import com.dstc.security.cms.OriginatorIdentifierOrKey;
import com.dstc.security.cms.OriginatorPublicKey;
import com.dstc.security.cms.RecipientEncryptedKey;
import com.dstc.security.cms.RecipientInfo;
import com.dstc.security.cms.crypto.KeyTrans;
import com.dstc.security.cms.crypto.KeyWrap;
import com.dstc.security.cms.crypto.RC2KeyWrap;
import com.dstc.security.cms.crypto.TripleDESKeyWrap;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.util.AbstractList;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class ContentKeyDecryptor {
    public static byte[] decryptKey(RecipientInfo recipientInfo, PrivateKey privateKey) throws CMSException {
        if (recipientInfo instanceof KeyTransRecipientInfo) {
            KeyTransRecipientInfo keyTransRecipientInfo = (KeyTransRecipientInfo)recipientInfo;
            KeyTrans keyTrans = new KeyTrans(null, keyTransRecipientInfo.getKeyEncryptionAlgorithm());
            keyTrans.setDecryptionKey(privateKey);
            return keyTrans.decrypt(keyTransRecipientInfo.getEncryptedKey());
        }
        KeyAgreeRecipientInfo keyAgreeRecipientInfo = (KeyAgreeRecipientInfo)recipientInfo;
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ESDH");
            keyAgreement.init(privateKey);
            DHParameterSpec dHParameterSpec = ((DHPrivateKey)privateKey).getParams();
            byte[] byArray = null;
            OriginatorIdentifierOrKey originatorIdentifierOrKey = keyAgreeRecipientInfo.getOriginatorIdentifierOrKey();
            if (!(originatorIdentifierOrKey instanceof OriginatorPublicKey)) {
                throw new CMSException("ESDH requires originator public key");
            }
            byArray = ((OriginatorPublicKey)originatorIdentifierOrKey).getPublicKeyBytes();
            Object object = (Integer)Asn1.getAsn1(byArray);
            Object object2 = new DHPublicKeySpec(((Integer)object).getBigInteger(), dHParameterSpec.getP(), dHParameterSpec.getG());
            Object object3 = KeyFactory.getInstance("DH");
            keyAgreement.doPhase(((KeyFactory)object3).generatePublic((KeySpec)object2), true);
            object = keyAgreement.generateSecret(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm());
            object2 = null;
            if (object.getAlgorithm().equals("DESede")) {
                object2 = new TripleDESKeyWrap(null);
            } else if (object.getAlgorithm().equals("RC2")) {
                object2 = new RC2KeyWrap(null);
            } else {
                throw new CMSException("key algorithm " + object.getAlgorithm() + " unsupported in CMS");
            }
            ((KeyWrap)object2).setKeyEncryptingKey(object.getEncoded());
            object3 = ((RecipientEncryptedKey)((AbstractList)keyAgreeRecipientInfo.getRecipientEncryptedKeys()).iterator().next()).getEncryptedKey();
            byte[] byArray2 = ((KeyWrap)object2).decrypt((byte[])object3);
            return byArray2;
        }
        catch (CMSException cMSException) {
            throw cMSException;
        }
        catch (Exception exception) {
            throw new CMSException("Content key decrypton error: nested exception is " + exception.toString());
        }
    }
}

