/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.crypto;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.crypto.ContentKeyEncryption;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;

public class KeyTrans
implements ContentKeyEncryption {
    protected String keyEncryptionAlg = null;
    protected Cipher cipher = null;
    protected SecureRandom rand = null;
    protected PublicKey keyEncryptingKey = null;
    protected PrivateKey keyDecryptingKey = null;

    public KeyTrans(SecureRandom secureRandom, String string) throws CMSException {
        try {
            this.rand = secureRandom;
            this.keyEncryptionAlg = string;
            this.cipher = Cipher.getInstance(string);
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    public byte[] decrypt(byte[] byArray) throws CMSException {
        byte[] byArray2 = this.doDecrypt(byArray);
        return byArray2;
    }

    private byte[] doDecrypt(byte[] byArray) throws CMSException {
        try {
            this.cipher.init(2, (Key)this.keyDecryptingKey, this.rand);
            return this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    private byte[] doEncrypt(byte[] byArray) throws CMSException {
        try {
            this.cipher.init(1, (Key)this.keyEncryptingKey, this.rand);
            return this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    public byte[] encrypt(byte[] byArray) throws CMSException {
        byte[] byArray2 = this.doEncrypt(byArray);
        return byArray2;
    }

    public void setDecryptionKey(PrivateKey privateKey) {
        this.keyDecryptingKey = privateKey;
    }

    public void setEncryptionKey(PublicKey publicKey) {
        this.keyEncryptingKey = publicKey;
    }
}

