/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.crypto;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.crypto.KeyWrap;
import java.security.SecureRandom;
import javax.crypto.Cipher;

public class RC2KeyWrap
extends KeyWrap {
    public RC2KeyWrap(SecureRandom secureRandom) throws CMSException {
        super(secureRandom);
        try {
            this.cipher = Cipher.getInstance("RC2/CBC/NoPadding");
            this.alg = "RC2";
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    protected byte[] postProcessKey(byte[] byArray) {
        byte[] byArray2 = new byte[byArray[0]];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    protected byte[] preProcessKey(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length + 1;
        int n2 = n % 8;
        byArray2 = n2 == 0 ? new byte[n] : new byte[n + 8 - n2];
        byArray2[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        if (n2 != 0) {
            byte[] byArray3 = new byte[8 - n2];
            this.rand.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, byArray2, byArray.length + 1, byArray3.length);
        }
        return byArray2;
    }
}

