/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.cms.CMSCipher;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.DecryptionResult;
import com.dstc.security.smime.SMIMEException;
import com.dstc.security.smime.handlers.EncryptedContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;

class SMIMEPart
extends MimeBodyPart {
    private CMSCipher cmsCipher = null;
    private SecureRandom rand = null;
    private String contentEncAlg;
    private X509Certificate[] recipients;
    private PrivateKey priv;
    private X509Certificate cert;

    SMIMEPart(PrivateKey privateKey, X509Certificate x509Certificate) {
        this.priv = privateKey;
        this.cert = x509Certificate;
    }

    SMIMEPart(Multipart multipart, SecureRandom secureRandom) throws MessagingException, IOException {
        this.rand = secureRandom;
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)multipart, multipart.getContentType());
        mimeBodyPart.addHeader("Content-Type", multipart.getContentType());
        mimeBodyPart.addHeader("Content-Transfer-Encoding", "7bit");
        this.initialize(mimeBodyPart);
    }

    SMIMEPart(MimeBodyPart mimeBodyPart, SecureRandom secureRandom) throws MessagingException, IOException {
        this.rand = secureRandom;
        this.initialize(mimeBodyPart);
    }

    DecryptionResult decrypt() throws SMIMEException {
        try {
            this.cmsCipher = new CMSCipher();
            this.cmsCipher.initDecrypt(this.priv, this.cert);
            this.cmsCipher.setDataToBeDecrypted((InputStream)this.getContent());
            return this.cmsCipher.decrypt();
        }
        catch (Exception exception) {
            throw new SMIMEException("Decryption error: nested exception is " + exception.toString());
        }
    }

    void encrypt() throws SMIMEException {
        try {
            this.cmsCipher.initEncrypt(this.rand, this.recipients, this.contentEncAlg);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage());
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            super.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.cmsCipher.setDataToBeEncrypted(new CMSTypedDataInputStream(byteArrayInputStream));
            super.setContent((Object)new EncryptedContent(this.cmsCipher), "application/x-pkcs7-mime; smime-type=enveloped-data");
            this.setHeader("Content-Transfer-Encoding", "base64");
            this.setHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            this.setHeader("Content-Description", "S/MIME Encrypted Message");
        }
        catch (Exception exception) {
            throw new SMIMEException("Encryption error: nested exception is " + exception.toString());
        }
    }

    void initialize(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        this.cmsCipher = new CMSCipher();
        this.setContent(mimeBodyPart.getContent(), mimeBodyPart.getContentType());
        this.setHeader("Content-Type", mimeBodyPart.getContentType());
        this.setHeader("Content-Transfer-Encoding", mimeBodyPart.getEncoding());
        this.setDisposition(mimeBodyPart.getDisposition());
        this.setDescription(mimeBodyPart.getDescription());
        if (mimeBodyPart.getFileName() != null) {
            this.setFileName(mimeBodyPart.getFileName());
        }
    }

    void setEncryptionAlgorithm(String string) throws SMIMEException {
        if (string == null) {
            throw new SMIMEException("Algorithm cannot be null");
        }
        this.contentEncAlg = string;
    }

    void setRecipients(X509Certificate[] x509CertificateArray) throws SMIMEException {
        this.recipients = x509CertificateArray;
    }
}

