/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.Factory;
import com.dstc.security.cms.IssuerAndSerialNumberImpl;
import com.dstc.security.cms.KeyTransRecipientInfo;
import com.dstc.security.cms.RecipientIdentifier;
import com.dstc.security.cms.crypto.KeyTrans;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.crypto.SecretKey;

final class KeyTransRecipientInfoImpl
implements KeyTransRecipientInfo {
    private Asn1 asn1 = null;
    private String keyEncryptionAlg;
    private PublicKey keyEncryptingKey;
    private int version = 0;
    private RecipientIdentifier rid;
    private byte[] encryptedKey;
    private SecureRandom rand = null;

    KeyTransRecipientInfoImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.version = ((Integer)iterator.next()).getInt();
        this.rid = Factory.getRecipientIdentifier((Asn1)iterator.next());
        this.keyEncryptionAlg = OID.getAlgName(new AlgorithmId((Asn1)iterator.next()).getOid());
        this.encryptedKey = ((OctetString)iterator.next()).getBytes();
    }

    KeyTransRecipientInfoImpl(SecureRandom secureRandom, X509Certificate x509Certificate, SecretKey secretKey) throws CMSException {
        this.rand = secureRandom;
        this.asn1 = new Sequence();
        this.asn1.add(new Integer(this.version));
        IssuerAndSerialNumberImpl issuerAndSerialNumberImpl = new IssuerAndSerialNumberImpl(x509Certificate);
        this.asn1.add(issuerAndSerialNumberImpl.getAsn1());
        this.keyEncryptionAlg = "RSA";
        this.asn1.add(new AlgorithmId("1.2.840.113549.1.1.1").getAsn1());
        KeyTrans keyTrans = new KeyTrans(this.rand, this.keyEncryptionAlg);
        keyTrans.setEncryptionKey(x509Certificate.getPublicKey());
        byte[] byArray = keyTrans.encrypt(secretKey.getEncoded());
        this.asn1.add(new OctetString(byArray));
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public int getCMSVersion() {
        return this.version;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public String getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlg;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        return this.rid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("KeyTransRecipientInfo");
        stringBuffer.append("\n[");
        stringBuffer.append("\n  Version: ").append(this.version);
        stringBuffer.append("\n  Recipient identifier: ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.rid.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\n    ").append(stringTokenizer.nextToken());
        }
        stringBuffer.append("\n  Key encryption algo: ");
        stringBuffer.append(this.getKeyEncryptionAlgorithm());
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

