/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.atts.MessageDigest;
import java.util.Iterator;

final class MessageDigestImpl
extends AttributeImpl
implements MessageDigest {
    private byte[] digest = null;

    MessageDigestImpl(String string, Set set) throws CMSException {
        this.type = string;
        this.values = set;
        Iterator iterator = set.components();
        Asn1 asn1 = (Asn1)iterator.next();
        if (asn1 == null) {
            throw new CMSException("Signing time cannot be empty");
        }
        if (!(asn1 instanceof OctetString)) {
            throw new CMSException("Badly encoded signing time");
        }
        this.digest = ((OctetString)asn1).getBytes();
    }

    MessageDigestImpl(byte[] byArray) {
        super("1.2.840.113549.1.9.4", new OctetString(byArray));
    }

    public byte[] getDigestBytes() {
        return this.digest;
    }

    private static final String hexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Message Digest: ");
        int n = 0;
        while (n < this.digest.length) {
            stringBuffer.append(MessageDigestImpl.hexDigit(this.digest[n]));
            ++n;
        }
        return stringBuffer.toString();
    }
}

