/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.atts.AlgorithmAndKeyLength;
import com.dstc.security.cms.atts.SMIMECapabilities;
import com.dstc.security.cms.atts.SMIMECapability;
import com.dstc.security.common.OID;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

final class SMIMECapabilitiesImpl
extends AttributeImpl
implements SMIMECapabilities {
    private Vector capabilities = null;

    SMIMECapabilitiesImpl(String string, Set set) throws CMSException {
        this.type = string;
        this.values = set;
        Asn1 asn1 = (Asn1)set.components().next();
        if (!(asn1 instanceof Sequence)) {
            throw new CMSException("Badly-formed SMIME capabilities");
        }
        Iterator iterator = asn1.components();
        this.capabilities = new Vector();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            try {
                asn12.info();
            }
            catch (Exception exception) {}
            if (!(asn12 instanceof Sequence)) {
                throw new CMSException("Badly encoded SMIME capabilities");
            }
            Iterator iterator2 = asn12.components();
            Asn1 asn13 = (Asn1)iterator2.next();
            if (!(asn13 instanceof Oid)) {
                throw new CMSException("Badly encoded SMIME capabilities");
            }
            String string2 = ((Oid)asn13).getOid();
            int n = 0;
            if (iterator2.hasNext() && (asn13 = (Asn1)iterator2.next()) != null && asn13 instanceof Integer) {
                n = ((Integer)asn13).getInt();
            }
            this.capabilities.add(new AlgAndKeyLengthImpl(string2, n));
        }
    }

    SMIMECapabilitiesImpl(Vector vector) {
        super("1.2.840.113549.1.9.15", SMIMECapabilitiesImpl.toASN1(vector));
    }

    public SMIMECapability[] getCapabilities() {
        if (this.capabilities == null) {
            return null;
        }
        SMIMECapability[] sMIMECapabilityArray = new SMIMECapability[this.capabilities.size()];
        this.capabilities.toArray(sMIMECapabilityArray);
        return sMIMECapabilityArray;
    }

    private static Asn1 toASN1(Vector vector) {
        Sequence sequence = new Sequence();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Sequence sequence2 = new Sequence();
            sequence2.add(new Oid((String)iterator.next()));
            sequence.add(sequence2);
        }
        return sequence;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SMIME Capabilities: ");
        stringBuffer.append(this.capabilities);
        return stringBuffer.toString();
    }

    class AlgAndKeyLengthImpl
    implements AlgorithmAndKeyLength {
        private String oid = null;
        private String alg = null;
        private int keyLength = 0;

        AlgAndKeyLengthImpl(String string, int n) {
            this.oid = string;
            this.keyLength = n;
        }

        public String getAlgorithmName() {
            return OID.getAlgName(this.oid);
        }

        public int getKeyLength() {
            return this.keyLength;
        }

        public String getObjectIdentifier() {
            return this.oid;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.oid);
            String string = this.getAlgorithmName();
            if (string != null) {
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            if (this.keyLength != 0) {
                stringBuffer.append(": ").append(this.keyLength).append(" bit");
            }
            return stringBuffer.toString();
        }
    }
}

