/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Signature;
import java.security.SignatureException;

class SignatureInputStream
extends FilterInputStream {
    private Signature sig;
    private byte[] buf;
    private int off;
    private String digestAlg;

    SignatureInputStream(InputStream inputStream, Signature signature, String string) {
        super(inputStream);
        this.sig = signature;
        this.digestAlg = string;
    }

    public int available() {
        return 0;
    }

    public void close() throws IOException {
        super.close();
    }

    private void getAllAndSign() throws IOException, SignatureException {
        if (!this.sig.getAlgorithm().equals("RawRSA")) {
            int n;
            byte[] byArray = new byte[64];
            while ((n = this.in.read(byArray)) != -1) {
                this.sig.update(byArray, 0, n);
            }
            this.buf = this.sig.sign();
            this.off = 0;
        } else {
            int n = 0;
            String string = null;
            if (this.digestAlg.equals("MD5")) {
                n = 16;
                string = "1.2.840.113549.2.5";
            } else if (this.digestAlg.startsWith("SHA")) {
                n = 20;
                string = "1.3.14.3.2.26";
            } else {
                throw new SignatureException("digest algorithm " + this.digestAlg + " unknown");
            }
            byte[] byArray = new byte[n];
            int n2 = this.in.read(byArray);
            if (n2 != n) {
                throw new IOException("Not enough bytes for " + this.digestAlg);
            }
            try {
                Sequence sequence = new Sequence();
                sequence.add(new AlgorithmId(string, null).getAsn1());
                sequence.add(new OctetString(byArray));
                this.sig.update(sequence.getEncoded());
                this.buf = this.sig.sign();
                this.off = 0;
            }
            catch (Exception exception) {
                throw new RuntimeException("Internal error: " + exception.getMessage());
            }
        }
    }

    public int read() throws IOException {
        try {
            if (this.buf == null) {
                this.getAllAndSign();
            }
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException.getMessage());
        }
        if (this.off == this.buf.length) {
            return -1;
        }
        ++this.off;
        return this.buf[this.off - 1];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        try {
            if (this.buf == null) {
                this.getAllAndSign();
            }
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException.getMessage());
        }
        if (this.off == this.buf.length) {
            return -1;
        }
        if (n2 <= this.buf.length - this.off) {
            System.arraycopy(this.buf, this.off, byArray, n, n2);
            this.off += n2;
            n3 = n2;
        } else {
            System.arraycopy(this.buf, this.off, byArray, n, this.buf.length - this.off);
            n3 = this.buf.length - this.off;
            this.off = this.buf.length;
        }
        return n3;
    }
}

