/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.smime;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSSignature;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.VerificationResult;
import com.dstc.security.smime.SMIMEException;
import com.dstc.security.smime.handlers.SignedContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;

class SMIMESignedPart
extends MimeBodyPart {
    private CMSSignature cmsSig = null;
    private SecureRandom rand = null;
    private String digestAlg;
    private PrivateKey priv;
    private X509Certificate[] certs;
    private Vector certStore;
    private Vector trusted;

    SMIMESignedPart() {
    }

    SMIMESignedPart(Multipart multipart) throws MessagingException, IOException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)multipart, multipart.getContentType());
        mimeBodyPart.addHeader("Content-Type", multipart.getContentType());
        mimeBodyPart.addHeader("Content-Transfer-Encoding", "7bit");
        this.initialize(mimeBodyPart);
    }

    SMIMESignedPart(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        this.initialize(mimeBodyPart);
    }

    void initialize(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        this.cmsSig = new CMSSignature();
        this.setContent(mimeBodyPart.getContent(), mimeBodyPart.getContentType());
        this.setHeader("Content-Type", mimeBodyPart.getContentType());
        this.setHeader("Content-Transfer-Encoding", mimeBodyPart.getEncoding());
        this.setDisposition(mimeBodyPart.getDisposition());
        this.setDescription(mimeBodyPart.getDescription());
        if (mimeBodyPart.getFileName() != null) {
            this.setFileName(mimeBodyPart.getFileName());
        }
    }

    void setCertStore(Vector vector) {
        this.certStore = vector;
    }

    void setDigestAlgorithm(String string) {
        this.digestAlg = string;
    }

    void setKeys(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.priv = privateKey;
        this.certs = x509CertificateArray;
    }

    void setTrustedCAs(Vector vector) {
        this.trusted = vector;
    }

    void sign() throws SMIMEException {
        try {
            this.cmsSig.initSign(this.priv, this.certs, this.digestAlg);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage());
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            super.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.cmsSig.setDataToBeSigned(new CMSTypedDataInputStream(byteArrayInputStream), true);
            super.setContent((Object)new SignedContent(this.cmsSig), "application/x-pkcs7-mime; smime-type=signed-data");
            this.setHeader("Content-Transfer-Encoding", "base64");
            this.setHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            this.setHeader("Content-Description", "S/MIME Signed Message");
        }
        catch (Exception exception) {
            throw new SMIMEException("Signing error: nested exception is " + exception.toString());
        }
    }

    VerificationResult verify() throws SMIMEException {
        try {
            this.cmsSig = new CMSSignature();
            this.cmsSig.initVerify(this.trusted, this.certStore);
            this.cmsSig.setDataToBeVerified((InputStream)this.getContent());
            return this.cmsSig.verify();
        }
        catch (Exception exception) {
            throw new SMIMEException("Verification error: nested exception is " + exception.toString());
        }
    }
}

