/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.common.Attribute;
import com.dstc.security.common.OID;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.common.X500Name;
import java.util.HashSet;
import java.util.Iterator;

class CertificationRequestInfo {
    private Asn1 asn1 = null;
    private int version;
    private X500Name subject;
    private SubjectPublicKeyInfo spki;
    private java.util.Set atts;

    public CertificationRequestInfo(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.version = ((Integer)iterator.next()).getInt();
        this.subject = new X500Name((Asn1)iterator.next());
        this.spki = new SubjectPublicKeyInfo((Asn1)iterator.next());
        if (!iterator.hasNext()) {
            return;
        }
        this.atts = new HashSet();
        Iterator iterator2 = ((Asn1)iterator.next()).components();
        while (iterator2.hasNext()) {
            this.atts.add(new Attribute((Asn1)iterator2.next()));
        }
    }

    public CertificationRequestInfo(X500Name x500Name, SubjectPublicKeyInfo subjectPublicKeyInfo, java.util.Set set) {
        this.asn1 = new Sequence();
        this.version = 0;
        this.asn1.add(new Integer(0));
        this.subject = x500Name;
        this.asn1.add(x500Name.getAsn1());
        this.spki = subjectPublicKeyInfo;
        this.asn1.add(subjectPublicKeyInfo.getAsn1());
        this.atts = set;
        if (set != null) {
            Set set2 = new Set();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                set2.add(((Attribute)iterator.next()).getAsn1());
            }
            set2.setTagClass(128);
            set2.setTagNumber(0);
            this.asn1.add(set2);
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public String getKeyAlgName() {
        return OID.getAlgName(this.getSubjectPublicKeyInfo().getAlgorithmId().getOid());
    }

    public java.util.Set getSignedAttributes() {
        return this.atts;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.spki;
    }
}

