/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.X500Name;
import com.dstc.security.pki.X509CRLGenException;
import com.dstc.security.util.Dependencies;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.GeneralName;
import com.dstc.security.x509.extns.AuthorityKeyIdentifier;
import com.dstc.security.x509.extns.CRLNumber;
import com.dstc.security.x509.extns.IssuerAltName;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;

public class X509CRLGen {
    private boolean signCalled = false;
    private Signature sigOb;
    private com.dstc.security.x509gen.X509CRL crl;
    private X509Certificate caCert = null;
    private IssuerAltName ian = new IssuerAltName();
    static /* synthetic */ Class class$com$dstc$security$pki$X509CRLGen;

    static {
        Dependencies.check(class$com$dstc$security$pki$X509CRLGen != null ? class$com$dstc$security$pki$X509CRLGen : (class$com$dstc$security$pki$X509CRLGen = X509CRLGen.class$("com.dstc.security.pki.X509CRLGen")), true);
    }

    public X509CRLGen() {
    }

    public X509CRLGen(String string, Signature signature) {
        X500Name x500Name = new X500Name(string);
        this.crl = new com.dstc.security.x509gen.X509CRL(x500Name, signature);
    }

    public X509CRLGen(PrivateKey privateKey, String string, String string2, X509Certificate x509Certificate) throws X509CRLGenException {
        try {
            this.sigOb = Signature.getInstance(string, string2);
            this.sigOb.initSign(privateKey);
            this.init(x509Certificate, this.sigOb);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new X509CRLGenException("No such algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new X509CRLGenException("Invalid key");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new X509CRLGenException("No such provider");
        }
    }

    public X509CRLGen(PrivateKey privateKey, String string, X509Certificate x509Certificate) throws X509CRLGenException {
        try {
            this.sigOb = Signature.getInstance(string);
            this.sigOb.initSign(privateKey);
            this.init(x509Certificate, this.sigOb);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new X509CRLGenException("No such algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new X509CRLGenException("Invalid key");
        }
    }

    public X509CRLGen(Signature signature, X509Certificate x509Certificate) {
        this.sigOb = signature;
        this.init(x509Certificate, this.sigOb);
    }

    public void addRevokedCert(BigInteger bigInteger) {
        this.crl.addRevokedCert(bigInteger, new Date(), null);
    }

    public void addRevokedCert(BigInteger bigInteger, Extensions extensions) {
        this.crl.addRevokedCert(bigInteger, new Date(), extensions);
    }

    public void addRevokedCert(BigInteger bigInteger, Date date) {
        this.crl.addRevokedCert(bigInteger, date, null);
    }

    public void addRevokedCert(BigInteger bigInteger, Date date, Extensions extensions) {
        this.crl.addRevokedCert(bigInteger, date, extensions);
    }

    public void addRevokedCert(X509CRLEntry x509CRLEntry) {
        this.crl.addRevokedCert(x509CRLEntry);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void deleteRevokedCert(BigInteger bigInteger) {
        this.crl.deleteRevokedCert(bigInteger);
    }

    public X509CRL generateCRL() throws X509CRLGenException {
        if (this.notReady()) {
            throw new X509CRLGenException("Required X.509 fields not set");
        }
        try {
            if (!this.signCalled) {
                this.sign();
            }
        }
        catch (SignatureException signatureException) {
            throw new X509CRLGenException("Signature error");
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CRLGenException("Encoding error");
        }
        return this.crl;
    }

    private void init(X509Certificate x509Certificate, Signature signature) {
        this.sigOb = signature;
        this.caCert = x509Certificate;
        X500Name x500Name = (X500Name)x509Certificate.getSubjectDN();
        this.crl = new com.dstc.security.x509gen.X509CRL(x500Name, signature);
    }

    private boolean notReady() {
        return this.crl.getThisUpdate() == null || this.crl.getNextUpdate() == null;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) throws X509CRLGenException {
        try {
            this.crl.addCRLExtension(new Extension("2.5.29.35", false, new AuthorityKeyIdentifier(true, byArray)));
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CRLGenException();
        }
        catch (IOException iOException) {
            throw new X509CRLGenException();
        }
    }

    public void setCRLNumber(BigInteger bigInteger) throws X509CRLGenException {
        try {
            this.crl.addCRLExtension(new Extension("2.5.29.20", false, new CRLNumber(bigInteger)));
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CRLGenException();
        }
    }

    public void setIssuerDNSName(String string) {
        this.ian.addAltName(new GeneralName(2, string));
    }

    public void setIssuerDirectoryName(String string) {
        this.ian.addAltName(new GeneralName(4, string));
    }

    public void setIssuerEmail(String string) {
        this.ian.addAltName(new GeneralName(1, string));
    }

    public void setIssuerIPAddress(String string) {
        this.ian.addAltName(new GeneralName(7, string));
    }

    public void setIssuerURL(String string) {
        this.ian.addAltName(new GeneralName(6, string));
    }

    public void setNextUpdate(Date date) {
        this.crl.setNextUpdate(date);
    }

    public void setRevokedCerts(Set set) {
        this.crl.setRevokedCerts(set);
    }

    public void setThisUpdate(Date date) {
        this.crl.setThisUpdate(date);
    }

    private void sign() throws SignatureException, Asn1Exception {
        if (this.ian.getNames() != null) {
            this.crl.addCRLExtension(new Extension("2.5.29.18", false, this.ian));
        }
        this.crl.sign();
        this.signCalled = true;
    }
}

