/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.X500Name;
import com.dstc.security.pki.PKCS10CertificationRequest;
import com.dstc.security.pki.PKIException;
import com.dstc.security.pki.X509CertGenException;
import com.dstc.security.util.Dependencies;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.GeneralName;
import com.dstc.security.x509.extns.IssuerAltName;
import com.dstc.security.x509.extns.SubjectAltName;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;

public class X509CertGen {
    private boolean signCalled = false;
    private Signature sigOb;
    private com.dstc.security.x509gen.X509Certificate userCert;
    private X509Certificate caCert = null;
    private SubjectAltName san = new SubjectAltName();
    private IssuerAltName ian = new IssuerAltName();
    static /* synthetic */ Class class$com$dstc$security$pki$X509CertGen;

    static {
        Dependencies.check(class$com$dstc$security$pki$X509CertGen != null ? class$com$dstc$security$pki$X509CertGen : (class$com$dstc$security$pki$X509CertGen = X509CertGen.class$("com.dstc.security.pki.X509CertGen")), true);
    }

    public X509CertGen() {
    }

    public X509CertGen(String string, Signature signature) {
        X500Name x500Name = new X500Name(string);
        this.userCert = new com.dstc.security.x509gen.X509Certificate(x500Name, signature);
    }

    public X509CertGen(PrivateKey privateKey, String string, String string2, X509Certificate x509Certificate) throws X509CertGenException {
        try {
            this.sigOb = Signature.getInstance(string, string2);
            this.sigOb.initSign(privateKey);
            this.init(x509Certificate, this.sigOb);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new X509CertGenException("No such algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new X509CertGenException("Invalid key");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new X509CertGenException("No such provider");
        }
    }

    public X509CertGen(PrivateKey privateKey, String string, X509Certificate x509Certificate) throws X509CertGenException {
        try {
            this.sigOb = Signature.getInstance(string);
            this.sigOb.initSign(privateKey);
            this.init(x509Certificate, this.sigOb);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new X509CertGenException("No such algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new X509CertGenException("Invalid key");
        }
    }

    public X509CertGen(Signature signature, X509Certificate x509Certificate) {
        this.sigOb = signature;
        this.init(x509Certificate, this.sigOb);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public X509Certificate generateCertificate() throws X509CertGenException {
        if (this.notReady()) {
            throw new X509CertGenException("Required X.509 fields not set");
        }
        if (!this.signCalled) {
            this.sign();
        }
        return this.userCert;
    }

    private void init(X509Certificate x509Certificate, Signature signature) {
        this.sigOb = signature;
        this.caCert = x509Certificate;
        X500Name x500Name = new X500Name(x509Certificate.getSubjectDN().toString());
        this.userCert = new com.dstc.security.x509gen.X509Certificate(x500Name, signature);
    }

    private boolean notReady() {
        return this.userCert.getSerialNumber() == null || this.userCert.getIssuerDN() == null || this.userCert.getSubjectDN() == null && this.san == null || this.userCert.getNotBefore() == null || this.userCert.getPublicKey() == null;
    }

    public void processPKCS10(PKCS10CertificationRequest pKCS10CertificationRequest) throws X509CertGenException {
        try {
            if (!pKCS10CertificationRequest.verifySignature()) {
                throw new X509CertGenException("Certificate request has bad signature");
            }
            this.setSubjectDN(pKCS10CertificationRequest.getSubjectName());
            KeyFactory keyFactory = KeyFactory.getInstance(pKCS10CertificationRequest.getKeyAlgName());
            this.setPublicKey(keyFactory.generatePublic(new X509EncodedKeySpec(pKCS10CertificationRequest.getSubjectPublicKeyInfo().getAsn1().getEncoded())));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new X509CertGenException();
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CertGenException();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new X509CertGenException();
        }
        catch (PKIException pKIException) {
            throw new X509CertGenException("Bad cert request");
        }
    }

    public void reset() throws X509CertGenException {
        X500Name x500Name = (X500Name)this.userCert.getIssuerDN();
        if (x500Name == null) {
            throw new X509CertGenException();
        }
        this.userCert = new com.dstc.security.x509gen.X509Certificate(x500Name, this.sigOb);
        this.san = new SubjectAltName();
        this.ian = new IssuerAltName();
        this.signCalled = false;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) throws X509CertGenException {
        try {
            this.userCert.setAuthorityKeyIdentifierExtension(byArray);
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CertGenException();
        }
        catch (IOException iOException) {
            throw new X509CertGenException();
        }
    }

    public void setBasicConstraints(boolean bl, int n) {
        this.userCert.setBasicConstraintsExtension(bl, n);
    }

    public void setIssuerDNSName(String string) {
        this.ian.addAltName(new GeneralName(2, string));
    }

    public void setIssuerDirectoryName(String string) {
        this.ian.addAltName(new GeneralName(4, string));
    }

    public void setIssuerEmail(String string) {
        this.ian.addAltName(new GeneralName(1, string));
    }

    public void setIssuerIPAddress(String string) {
        this.ian.addAltName(new GeneralName(7, string));
    }

    public void setIssuerURL(String string) {
        this.ian.addAltName(new GeneralName(6, string));
    }

    public void setKeyUsage(boolean[] blArray) throws X509CertGenException {
        try {
            short s = 0;
            int n = 0;
            while (n < blArray.length) {
                if (blArray[n]) {
                    s = (short)(s | 32768 >>> n);
                }
                ++n;
            }
            this.userCert.setKeyUsageExtension(s);
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CertGenException();
        }
        catch (IOException iOException) {
            throw new X509CertGenException();
        }
    }

    public void setNetscapeCertType(boolean[] blArray) {
        byte by = 0;
        int n = 0;
        while (n < 4) {
            if (blArray[n]) {
                by = (byte)(by | 128 >>> n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            if (blArray[n2 + 4]) {
                by = (byte)(by | 4 >>> n2);
            }
            ++n2;
        }
        this.userCert.setNetscapeCertTypeExtension(by);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.userCert.setPublicKey(publicKey);
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.userCert.setSerialNumber(bigInteger);
    }

    public void setSubjectDN(String string) {
        this.userCert.setSubjectDN(string);
    }

    public void setSubjectDNSName(String string) {
        this.san.addAltName(new GeneralName(2, string));
    }

    public void setSubjectDirectoryName(String string) {
        this.san.addAltName(new GeneralName(4, string));
    }

    public void setSubjectEmail(String string) {
        this.san.addAltName(new GeneralName(1, string));
    }

    public void setSubjectIPAddress(String string) {
        this.san.addAltName(new GeneralName(7, string));
    }

    public void setSubjectKeyIdentifier(byte[] byArray) throws X509CertGenException {
        try {
            this.userCert.setSubjectKeyIdentifierExtension(byArray);
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CertGenException();
        }
        catch (IOException iOException) {
            throw new X509CertGenException();
        }
    }

    public void setSubjectURL(String string) {
        this.san.addAltName(new GeneralName(6, string));
    }

    public void setValidity(int n) {
        this.userCert.setValidityPeriodInDays(n);
    }

    public void setValidity(Date date, Date date2) {
        this.userCert.setValidity(date, date2);
    }

    private void sign() throws X509CertGenException {
        if (this.userCert.getExtensionValue("2.5.29.19") == null) {
            this.setBasicConstraints(false, -1);
        }
        if (this.caCert != null && (this.userCert.getNotBefore().before(this.caCert.getNotBefore()) || this.userCert.getNotAfter().after(this.caCert.getNotAfter()))) {
            throw new X509CertGenException("The validity period of the user cert is outside that of the ca cert");
        }
        try {
            boolean bl = false;
            if (this.san.getNames() != null) {
                if (this.userCert.getSubjectDN() == null) {
                    bl = true;
                }
                this.userCert.addCertExtension(new Extension("2.5.29.17", bl, this.san));
            }
            if (this.ian.getNames() != null) {
                this.userCert.addCertExtension(new Extension("2.5.29.18", false, this.ian));
            }
            this.userCert.sign();
            this.signCalled = true;
        }
        catch (SignatureException signatureException) {
            throw new X509CertGenException("signing error");
        }
        catch (Asn1Exception asn1Exception) {
            throw new X509CertGenException("certificate encoding error");
        }
    }
}

