/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509gen;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.common.X500Name;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509gen.X509CRLEntry;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class TbsCertList
extends com.dstc.security.x509.TbsCertList {
    public TbsCertList(String string, X500Name x500Name) {
        this.sigAlgo = new AlgorithmId(OID.getAlgOid(string));
        this.issuer = x500Name;
    }

    void addExtension(Extension extension) {
        if (this.extns == null) {
            this.extns = new Extensions();
        }
        this.extns.addExtension(extension);
    }

    void addRevokedCert(X509CRLEntry x509CRLEntry) {
        if (this.revCerts == null) {
            this.revCerts = new HashSet();
        }
        this.revCerts.add(x509CRLEntry);
    }

    void deleteRevokedCert(BigInteger bigInteger) {
        if (this.revCerts == null) {
            return;
        }
        Iterator iterator = this.revCerts.iterator();
        while (iterator.hasNext()) {
            X509CRLEntry x509CRLEntry = (X509CRLEntry)iterator.next();
            if (!x509CRLEntry.getSerialNumber().equals(bigInteger)) continue;
            this.revCerts.remove(x509CRLEntry);
            return;
        }
    }

    void encode() {
        Object object;
        this.asn1 = new Sequence();
        Vector vector = null;
        if (this.extns != null) {
            vector = this.extns.getExtensions();
        }
        this.asn1.add(new Integer(this.version));
        this.asn1.add(this.sigAlgo.getAsn1());
        this.asn1.add(this.issuer.getAsn1());
        if (this.thisUpdate == null) {
            this.thisUpdate = new UTCTime(0);
        }
        this.asn1.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            this.asn1.add(this.nextUpdate);
        }
        Sequence sequence = new Sequence();
        if (this.revCerts != null) {
            object = this.revCerts.iterator();
            while (object.hasNext()) {
                sequence.add(((X509CRLEntry)object.next()).getAsn1());
            }
        }
        this.asn1.add(sequence);
        if (vector != null) {
            object = new Sequence();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                ((Asn1)object).add(((Extension)iterator.next()).getAsn1());
            }
            Explicit explicit = new Explicit(128, 0);
            explicit.add((Asn1)object);
            this.asn1.add(explicit);
        }
    }

    void setExtensions(Vector vector) {
        this.extns = new Extensions(vector);
    }

    void setNextUpdate(Date date) {
        this.nextUpdate = new UTCTime(date);
    }

    void setRevokedCerts(Set set) {
        this.revCerts = new HashSet();
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                X509CRLEntry x509CRLEntry = new X509CRLEntry(Asn1.getAsn1(((java.security.cert.X509CRLEntry)iterator.next()).getEncoded()));
                this.revCerts.add(x509CRLEntry);
            }
        }
        catch (IOException iOException) {
        }
        catch (Asn1Exception asn1Exception) {
        }
        catch (CRLException cRLException) {}
    }

    void setThisUpdate(Date date) {
        this.thisUpdate = new UTCTime(date);
    }
}

