/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509gen;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.common.X500Name;
import com.dstc.security.util.Dependencies;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.extns.AuthorityKeyIdentifier;
import com.dstc.security.x509.extns.BasicConstraints;
import com.dstc.security.x509.extns.IssuerAltName;
import com.dstc.security.x509.extns.KeyUsage;
import com.dstc.security.x509.extns.NetscapeCertType;
import com.dstc.security.x509.extns.SubjectAltName;
import com.dstc.security.x509.extns.SubjectKeyIdentifier;
import com.dstc.security.x509gen.TBSCertificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Vector;

public class X509Certificate
extends com.dstc.security.x509.X509Certificate {
    public static final int VERSION_1 = 0;
    public static final int VERSION_3 = 2;
    private Signature sig;
    static /* synthetic */ Class class$com$dstc$security$x509gen$X509Certificate;

    static {
        Dependencies.check(class$com$dstc$security$x509gen$X509Certificate != null ? class$com$dstc$security$x509gen$X509Certificate : (class$com$dstc$security$x509gen$X509Certificate = X509Certificate.class$("com.dstc.security.x509gen.X509Certificate")), true);
    }

    public X509Certificate() {
    }

    public X509Certificate(X500Name x500Name, Signature signature) {
        this.sig = signature;
        this.sigAlg = new AlgorithmId(OID.getAlgOid(signature.getAlgorithm()));
        this.tbs = new TBSCertificate(2, this.sigAlg, x500Name);
    }

    public void addCertExtension(Extension extension) {
        ((TBSCertificate)this.tbs).addExtension(extension);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAuthorityKeyIdentifierExtension(byte[] byArray) throws Asn1Exception, IOException {
        ((TBSCertificate)this.tbs).addExtension(new Extension("2.5.29.35", false, new AuthorityKeyIdentifier(true, byArray)));
    }

    public void setBasicConstraintsExtension(boolean bl, int n) {
        try {
            ((TBSCertificate)this.tbs).addExtension(new Extension("2.5.29.19", true, new BasicConstraints(bl, n)));
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("bad Asn1 encoding");
        }
    }

    public void setCertExtensions(Vector vector) {
        ((TBSCertificate)this.tbs).setExtensions(vector);
    }

    public void setIssuerAltNameExtension(String string) {
        try {
            ((TBSCertificate)this.tbs).addExtension(new Extension("2.5.29.18", false, new IssuerAltName(string)));
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("bad Asn1 encoding");
        }
    }

    public void setKeyUsageExtension(short s) throws Asn1Exception, IOException {
        ((TBSCertificate)this.tbs).addExtension(new Extension("2.5.29.15", true, new KeyUsage(s)));
    }

    public void setNetscapeCertTypeExtension(byte by) {
        try {
            ((TBSCertificate)this.tbs).addExtension(new Extension("2.16.840.1.113730.1.1", false, new NetscapeCertType(by)));
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("bad Asn1 encoding");
        }
    }

    public void setPublicKey(PublicKey publicKey) {
        try {
            ((TBSCertificate)this.tbs).setPublicKey(publicKey);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("bad encoding");
        }
    }

    public void setSerialNumber(BigInteger bigInteger) {
        ((TBSCertificate)this.tbs).setSerialNumber(bigInteger);
    }

    public void setSubjectAltNameExtension(String string) {
        boolean bl = false;
        if (this.tbs.getSubject() == null) {
            bl = true;
        }
        try {
            ((TBSCertificate)this.tbs).addExtension(new Extension("2.5.29.17", bl, new SubjectAltName(string)));
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("bad Asn1 encoding");
        }
    }

    public void setSubjectDN(String string) {
        ((TBSCertificate)this.tbs).setSubjectDN(new X500Name(string));
    }

    public void setSubjectKeyIdentifierExtension(byte[] byArray) throws Asn1Exception, IOException {
        ((TBSCertificate)this.tbs).addExtension(new Extension("2.5.29.14", false, new SubjectKeyIdentifier(byArray)));
    }

    public void setValidity(Date date, Date date2) {
        ((TBSCertificate)this.tbs).setValidity(date, date2);
    }

    public void setValidityPeriodInDays(int n) {
        ((TBSCertificate)this.tbs).setValidityPeriodInDays(n);
    }

    public void sign() throws SignatureException, Asn1Exception {
        this.asn1 = new Sequence();
        ((TBSCertificate)this.tbs).encode();
        this.asn1.add(this.tbs.getAsn1());
        this.asn1.add(this.sigAlg.getAsn1());
        this.sig.update(this.tbs.getAsn1().getEncoded());
        this.sigData = this.sig.sign();
        this.asn1.add(new BitString(this.sigData));
    }
}

