/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.certpath;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class X509CertSelector {
    private String issuer = null;
    private BigInteger serialNumber = null;
    private byte[] ski = null;

    private boolean checkIssuerDN(X509Certificate x509Certificate) {
        return x509Certificate.getIssuerDN().getName().equals(this.issuer);
    }

    private boolean checkSerialNumber(X509Certificate x509Certificate) {
        return x509Certificate.getSerialNumber().equals(this.serialNumber);
    }

    private boolean checkSubjectKeyIdentifier(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.14");
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return Arrays.equals(this.ski, byArray2);
    }

    public boolean match(X509Certificate x509Certificate) {
        if (this.issuer != null && !this.checkIssuerDN(x509Certificate)) {
            return false;
        }
        if (this.serialNumber != null && !this.checkSerialNumber(x509Certificate)) {
            return false;
        }
        if (this.ski != null) {
            System.out.println("Sel:ski");
            if (!this.checkSubjectKeyIdentifier(x509Certificate)) {
                return false;
            }
        }
        return true;
    }

    public void setIssuerDN(String string) {
        this.issuer = string;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.ski = byArray;
    }
}

