/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.DirectoryString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.PrintableString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.OID;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class AttributeTypeAndValue {
    private Asn1 asn1 = null;
    private String type;
    private String friendly;
    private String value;

    public AttributeTypeAndValue(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.type = ((Oid)iterator.next()).getOid();
        this.friendly = OID.getAlgName(this.type);
        Asn1 asn12 = (Asn1)iterator.next();
        try {
            this.value = ((DirectoryString)asn12).getString();
            return;
        }
        catch (ClassCastException classCastException) {
            this.value = ((IA5String)asn12).getString();
            return;
        }
    }

    public AttributeTypeAndValue(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public AttributeTypeAndValue(String string, String string2) {
        if (string.startsWith("OID")) {
            this.type = string.substring(4);
            this.friendly = OID.getAlgName(string);
        } else {
            this.type = OID.getAlgOid(string);
            this.friendly = string;
        }
        this.asn1 = new Sequence();
        this.asn1.add(new Oid(this.type));
        this.value = string2;
        if (!this.type.equals("1.2.840.113549.1.9.1")) {
            this.asn1.add(new PrintableString(string2));
        } else {
            this.asn1.add(new IA5String(string2));
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getName() {
        if (this.friendly != null) {
            return String.valueOf(this.friendly) + "=" + this.quote(this.value);
        }
        return "OID." + this.type + "=" + this.quote(this.value);
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    private String quote(String string) {
        if (string.indexOf(",") == -1 || string.indexOf("\"") != -1) {
            return string;
        }
        return "\"" + string + "\"";
    }
}

