/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12.bags;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.keymanage.debug.Debug;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class KeyBag {
    private Asn1 asn1;
    private int version = 0;
    private AlgorithmId privateKeyAlgorithm;
    private byte[] key;

    public KeyBag(Asn1 asn1) throws Asn1Exception {
        Debug.dumpAsn1To(asn1, "keybag");
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            this.version = ((Integer)iterator.next()).getInt();
            this.privateKeyAlgorithm = new AlgorithmId((Asn1)iterator.next());
            OctetString octetString = (OctetString)iterator.next();
            this.key = octetString.getBytes();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Invalid KeyBag ASN.1");
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid KeyBag ASN.1");
        }
    }

    public KeyBag(AlgorithmId algorithmId, byte[] byArray) {
        this.privateKeyAlgorithm = algorithmId;
        this.key = byArray;
        this.asn1 = new Sequence();
        this.asn1.add(new Integer(this.version));
        this.asn1.add(this.privateKeyAlgorithm.getAsn1());
        OctetString octetString = new OctetString(this.key);
        this.asn1.add(octetString);
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getKey() {
        return this.key;
    }

    public PrivateKey getPrivateKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(this.key);
        String string = OID.getAlgName(this.privateKeyAlgorithm.getOid());
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public AlgorithmId getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public String getType() {
        return "1.2.840.113549.1.12.10.1.1";
    }
}

