/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.util;

import com.dstc.security.common.PKCS12KeyDerivation;
import com.dstc.security.keymanage.debug.Debug;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PKCS12KeyFactory {
    public static final String MAC_ALGORITHM = "HMACwithSHA1";
    public static final String MD_ALGORITHM = "SHA";
    public static final String DIGEST_OID = "1.3.14.3.2.26";
    private static final int HASH_LENGTH = 20;

    public static SecretKey createPBEKey(char[] cArray) {
        Debug.log(1, "PKCS12KeyFactory.createPBEKey( char[] )", "CharArray: " + new String(cArray));
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEwithSHAand3-KeyTripleDES-CBC");
            return secretKeyFactory.generateSecret(new PBEKeySpec(cArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal error: " + noSuchAlgorithmException.toString());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("Internal error: " + invalidKeySpecException.toString());
        }
    }

    public static SecretKey generateMacKey(SecretKey secretKey, PBEParameterSpec pBEParameterSpec) throws InvalidKeyException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(MD_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.log(1, "PKCS12KeyFactory.generateMacKey()", noSuchAlgorithmException.toString());
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        PKCS12KeyDerivation pKCS12KeyDerivation = new PKCS12KeyDerivation();
        byte[] byArray = null;
        try {
            byArray = pKCS12KeyDerivation.generateKey(3, messageDigest, secretKey, pBEParameterSpec, 20);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Debug.log(5, "PKCS12KeyFactory.generateMacKey()", invalidAlgorithmParameterException.toString());
        }
        return new SecretKeySpec(byArray, "HMAC");
    }

    public static PBEParameterSpec generatePBEParameterSpec() {
        byte[] byArray = PKCS12KeyFactory.generateSalt();
        int n = 1;
        return new PBEParameterSpec(byArray, n);
    }

    public static byte[] generateSalt() {
        return "Hello".getBytes();
    }
}

