/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.x509.ExtensionValue;
import com.dstc.security.x509.extns.AuthorityKeyIdentifier;
import com.dstc.security.x509.extns.BasicConstraints;
import com.dstc.security.x509.extns.CRLDistributionPoints;
import com.dstc.security.x509.extns.CRLNumber;
import com.dstc.security.x509.extns.CertificatePolicies;
import com.dstc.security.x509.extns.ExtendedKeyUsage;
import com.dstc.security.x509.extns.IssuerAltName;
import com.dstc.security.x509.extns.KeyUsage;
import com.dstc.security.x509.extns.NameConstraints;
import com.dstc.security.x509.extns.NetscapeCertType;
import com.dstc.security.x509.extns.PolicyConstraints;
import com.dstc.security.x509.extns.SubjectAltName;
import com.dstc.security.x509.extns.SubjectKeyIdentifier;
import java.security.cert.X509Certificate;

public class ExtensionFactory {
    public static ExtensionValue getExtension(String string, Asn1 asn1) {
        try {
            ExtensionValue extensionValue = null;
            Asn1 asn12 = Asn1.getAsn1(((OctetString)asn1).getBytes());
            if (string.equals("2.16.840.1.113730.1.1")) {
                return new NetscapeCertType(asn12);
            }
            if (string.equals("2.5.29.19")) {
                return new BasicConstraints(asn12);
            }
            if (string.equals("2.5.29.35")) {
                return new AuthorityKeyIdentifier(asn12);
            }
            if (string.equals("2.5.29.14")) {
                return new SubjectKeyIdentifier(asn12);
            }
            if (string.equals("2.5.29.15")) {
                return new KeyUsage(asn12);
            }
            if (string.equals("2.5.29.18")) {
                return new IssuerAltName(asn12);
            }
            if (string.equals("2.5.29.17")) {
                return new SubjectAltName(asn12);
            }
            if (string.equals("2.5.29.36")) {
                return new PolicyConstraints(asn12);
            }
            if (string.equals("2.5.29.30")) {
                return new NameConstraints(asn12);
            }
            if (string.equals("2.5.29.37")) {
                return new ExtendedKeyUsage(asn12);
            }
            if (string.equals("2.5.29.31")) {
                return new CRLDistributionPoints(asn12);
            }
            if (string.equals("2.5.29.20")) {
                return new CRLNumber(asn12);
            }
            if (string.equals("2.5.29.32")) {
                return new CertificatePolicies(asn12);
            }
            return extensionValue;
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public static ExtensionValue getExtension(String string, X509Certificate x509Certificate) throws Asn1Exception {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return ExtensionFactory.getExtension(string, Asn1.getAsn1(byArray));
    }
}

