/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.util.Base64InputStream;
import com.dstc.security.util.DegeneratePKCS7;
import com.dstc.security.x509.Licensed;
import com.dstc.security.x509.X509CRL;
import com.dstc.security.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Vector;

public class X509CertificateFactory
extends CertificateFactorySpi
implements Licensed {
    private static final byte[] HEADER = "-----BEGIN CERTIFICATE-----".getBytes();
    private static final byte[] FOOTER = "-----END CERTIFICATE-----\n".getBytes();
    private static final byte[] HEADER7 = "-----BEGIN PKCS7-----".getBytes();
    private static final byte[] FOOTER7 = "-----END PKCS7-----\n".getBytes();

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        try {
            return new X509CRL(inputStream);
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.toString());
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 129);
        byte[] byArray = new byte[129];
        Vector<X509CRL> vector = new Vector<X509CRL>();
        try {
            boolean bl = X509CertificateFactory.isX509orPKCS7(byArray, pushbackInputStream);
            int n = X509CertificateFactory.getNonZero(byArray);
            pushbackInputStream.unread(byArray, 0, n);
            if (bl) {
                InputStream inputStream2 = X509CertificateFactory.makeAvailableStream(pushbackInputStream);
                while (inputStream2.available() > 0) {
                    vector.add(new X509CRL(inputStream2));
                }
                return vector;
            }
            DegeneratePKCS7 degeneratePKCS7 = new DegeneratePKCS7(pushbackInputStream);
            return degeneratePKCS7.getCRLs();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.toString());
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CRLException(certificateException.toString());
        }
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        InputStream inputStream2 = null;
        inputStream2 = X509CertificateFactory.isBase64(inputStream, HEADER, FOOTER);
        try {
            return new X509Certificate(inputStream2);
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 129);
            byte[] byArray = new byte[129];
            boolean bl = false;
            Vector<Certificate> vector = new Vector<Certificate>();
            byArray[0] = (byte)(pushbackInputStream.read() & 0xFF);
            if (byArray[0] == HEADER[0]) {
                int n = 0;
                while (n < 11) {
                    byArray[n + 1] = (byte)pushbackInputStream.read();
                    ++n;
                }
                if (byArray[11] == 80) {
                    int n2 = X509CertificateFactory.getNonZero(byArray);
                    pushbackInputStream.unread(byArray, 0, n2);
                    InputStream inputStream2 = X509CertificateFactory.isBase64(pushbackInputStream, HEADER7, FOOTER7);
                    DegeneratePKCS7 degeneratePKCS7 = new DegeneratePKCS7(inputStream2);
                    return degeneratePKCS7.getCertificates();
                }
                int n3 = X509CertificateFactory.getNonZero(byArray);
                pushbackInputStream.unread(byArray, 0, n3);
                InputStream inputStream3 = X509CertificateFactory.makeAvailableStream(pushbackInputStream);
                while (inputStream3.available() > 0) {
                    vector.add(this.engineGenerateCertificate(inputStream3));
                }
                return vector;
            }
            pushbackInputStream.unread(byArray[0]);
            boolean bl2 = X509CertificateFactory.isX509orPKCS7(byArray, pushbackInputStream);
            int n = X509CertificateFactory.getNonZero(byArray);
            pushbackInputStream.unread(byArray, 0, n);
            if (bl2) {
                InputStream inputStream4 = X509CertificateFactory.makeAvailableStream(pushbackInputStream);
                while (inputStream4.available() > 0) {
                    vector.add(new X509Certificate(inputStream4));
                }
                return vector;
            }
            DegeneratePKCS7 degeneratePKCS7 = new DegeneratePKCS7(pushbackInputStream);
            return degeneratePKCS7.getCertificates();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CertificateException(asn1Exception.toString());
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
        catch (CRLException cRLException) {
            throw new CertificateException(cRLException.toString());
        }
    }

    private static int getNonZero(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            if (byArray[n] != 0) break;
            --n;
        }
        return n + 1;
    }

    private static InputStream isBase64(InputStream inputStream, byte[] byArray, byte[] byArray2) throws CertificateException {
        InputStream inputStream2;
        boolean bl;
        block18: {
            if (inputStream.markSupported()) {
                inputStream.mark(10);
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = inputStream.read();
                if (n == -1) {
                    throw new CertificateEncodingException("Unexpected end of stream");
                }
                if (n == byArray[0]) {
                    bl = true;
                    int n2 = 1;
                    while (n2 < byArray.length) {
                        n = inputStream.read();
                        if (n == -1) {
                            throw new CertificateEncodingException("Unexpected end of stream");
                        }
                        if (n != byArray[n2]) {
                            throw new CertificateEncodingException("Bad header");
                        }
                        ++n2;
                    }
                    while (true) {
                        if ((n = inputStream.read()) == -1) {
                            throw new CertificateEncodingException("Unexpected end of stream");
                        }
                        if (n == byArray2[0]) {
                            int n3 = 1;
                            while (n3 < byArray2.length) {
                                n = inputStream.read();
                                if (n == -1) {
                                    throw new CertificateEncodingException("Unexpected end of stream");
                                }
                                if (n != byArray2[n3]) {
                                    throw new CertificateEncodingException("Bad footer");
                                }
                                ++n3;
                            }
                            break;
                        }
                        byteArrayOutputStream.write((byte)(n & 0xFF));
                    }
                    inputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    break block18;
                }
                bl = false;
                if (inputStream.markSupported()) {
                    inputStream.reset();
                    inputStream2 = inputStream;
                } else {
                    byteArrayOutputStream.write((byte)(n & 0xFF));
                    while ((n = inputStream.read()) != -1) {
                        byteArrayOutputStream.write((byte)(n & 0xFF));
                    }
                    inputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
            }
            catch (IOException iOException) {
                throw new CertificateException("IO error: " + iOException.getMessage());
            }
        }
        if (!bl) {
            return inputStream2;
        }
        return new Base64InputStream(inputStream2);
    }

    private static boolean isX509orPKCS7(byte[] byArray, PushbackInputStream pushbackInputStream) throws CertificateException {
        boolean bl;
        block6: {
            bl = false;
            int n = 0;
            try {
                byArray[0] = (byte)(pushbackInputStream.read() & 0xFF);
                byArray[1] = (byte)(pushbackInputStream.read() & 0xFF);
                if ((byArray[1] & 0x80) != 0) {
                    n = byArray[1] & 0x7F;
                    int n2 = 2;
                    while (n2 != n + 2) {
                        byArray[n2++] = (byte)(pushbackInputStream.read() & 0xFF);
                    }
                }
                byArray[n + 2] = (byte)(pushbackInputStream.read() & 0xFF);
                if (byArray[n + 2] == 48) {
                    bl = true;
                    break block6;
                }
                if (byArray[n + 2] == 6) {
                    bl = false;
                    break block6;
                }
                throw new CertificateException("Unrecognized Format");
            }
            catch (IOException iOException) {
                throw new CertificateException("Encoding error");
            }
        }
        return bl;
    }

    static InputStream makeAvailableStream(InputStream inputStream) throws IOException {
        int n;
        if (inputStream instanceof ByteArrayInputStream) {
            return inputStream;
        }
        byte[] byArray = new byte[128];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}

