/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1String;
import com.dstc.security.asn1.BMPString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.UTF8String;
import com.dstc.security.asn1.VisibleString;
import java.io.IOException;

public class DisplayText {
    private Asn1String text;
    private static final int MAX_TEXT_LENGTH = 200;

    public DisplayText(Asn1 asn1) throws IOException {
        if (asn1 instanceof VisibleString || asn1 instanceof BMPString || asn1 instanceof UTF8String) {
            this.text = (Asn1String)asn1;
        } else if (asn1 instanceof IA5String) {
            this.text = (Asn1String)asn1;
        } else {
            throw new IOException("Expecting VisibleString, BMPString, UTF8String in DisplayText " + asn1);
        }
    }

    public DisplayText(Asn1String asn1String) throws IOException {
        if (asn1String instanceof VisibleString || asn1String instanceof BMPString || asn1String instanceof UTF8String) {
            if (asn1String.getString().length() > 200) {
                throw new IOException("Text exceed allowed length (200)");
            }
        } else {
            throw new IOException("Only VisibleString, BMPString or UTF8String allowed");
        }
        this.text = asn1String;
    }

    public Asn1 getAsn1() {
        return this.text;
    }

    public String getText() {
        return this.text.getString();
    }

    public String toString() {
        return this.getText();
    }
}

