/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.GeneralName;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class GeneralSubtree {
    private Asn1 asn1 = null;
    private GeneralName base = null;
    private int minBaseDistance = 0;
    private int maxBaseDistance = -1;
    private final int MIN_BASEDISTANCE_ASN1_TAG = 0;
    private final int MAX_BASEDISTANCE_ASN1_TAG = 1;

    public GeneralSubtree(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.base = new GeneralName((Asn1)iterator.next());
        if (!iterator.hasNext()) {
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.minBaseDistance = new BigInteger(asn12.getValue()).intValue();
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 1) {
            this.maxBaseDistance = new BigInteger(asn12.getValue()).intValue();
            if (!iterator.hasNext()) {
                return;
            }
        }
        throw new Asn1Exception("Unknown GeneralSubtree data structure");
    }

    public GeneralSubtree(GeneralName generalName) throws IOException {
        this(generalName, 0);
    }

    public GeneralSubtree(GeneralName generalName, int n) throws IOException {
        this(generalName, n, -1);
    }

    public GeneralSubtree(GeneralName generalName, int n, int n2) throws IOException {
        Integer integer;
        this.asn1 = new Sequence();
        this.base = generalName;
        this.asn1.add(generalName.getAsn1());
        if (n < 0) {
            n = 0;
        }
        if (n > 0) {
            this.minBaseDistance = n;
            integer = new Integer(this.minBaseDistance);
            integer.setTagClass(128);
            integer.setTagNumber(0);
            this.asn1.add(integer);
        }
        if (n2 > 0) {
            this.maxBaseDistance = n2;
            integer = new Integer(this.maxBaseDistance);
            integer.setTagClass(128);
            integer.setTagNumber(1);
            this.asn1.add(integer);
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public GeneralName getBaseName() {
        return this.base;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n    Name: " + this.base.getName() + "\n");
        stringBuffer.append("    Min Base Distance: " + this.minBaseDistance + "\n");
        if (this.maxBaseDistance > 0) {
            stringBuffer.append("    Max Base Distance: " + this.maxBaseDistance + "\n");
        }
        return stringBuffer.toString();
    }
}

