/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.AuthorizationDataElement;
import java.util.Iterator;

class AuthDataElement
implements AuthorizationDataElement {
    private Asn1 asn1 = null;
    private int adType;
    private byte[] adData;

    AuthDataElement(int n, byte[] byArray) {
        this.asn1 = new Sequence();
        this.adType = n;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new com.dstc.security.asn1.Integer(n));
        this.asn1.add(explicit);
        this.adData = byArray;
        explicit = new Explicit(128, 1);
        explicit.add(new OctetString(byArray));
        this.asn1.add(explicit);
    }

    AuthDataElement(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.adType = ((com.dstc.security.asn1.Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        this.adData = ((OctetString)asn12.components().next()).getBytes();
    }

    public byte[] data() {
        return this.adData;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.adType).append(",  ");
        int n = 0;
        while (n < this.adData.length) {
            stringBuffer.append(String.valueOf(Integer.toHexString(this.adData[n] & 0xFF)) + " ");
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int type() {
        return this.adType;
    }
}

