/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.util.Iterator;

public class Checksum {
    private Asn1 asn1 = null;
    private int cksumType;
    private byte[] cksum;

    public Checksum(int n, byte[] byArray) {
        this.asn1 = new Sequence();
        this.cksumType = n;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(n));
        this.asn1.add(explicit);
        this.cksum = byArray;
        explicit = new Explicit(128, 1);
        explicit.add(new OctetString(byArray));
        this.asn1.add(explicit);
    }

    Checksum(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cksumType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cksum = ((OctetString)asn12.components().next()).getBytes();
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getBytes() {
        return this.cksum;
    }

    public int getType() {
        return this.cksumType;
    }
}

