/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.HostAddress;
import com.dstc.security.kerberos.KrbCredInfoImpl;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class EncKrbCredPart {
    public static final int TAG_KRB_ENC_KRB_CRED_PART = 29;
    private Asn1 asn1 = null;
    private Vector credsInfo;
    private int nonce = -1;
    private Date timestamp;
    private int usec = 0;
    private InetAddress sAddress;
    private InetAddress rAddress;

    EncKrbCredPart(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        if (this.asn1.getTagNumber() != 29) {
            throw new Asn1Exception("Bad Tag Number");
        }
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        this.credsInfo = new Vector();
        Asn1 asn12 = (Asn1)iterator.next();
        Iterator iterator2 = ((Sequence)asn12.components().next()).components();
        while (iterator2.hasNext()) {
            this.credsInfo.add(new KrbCredInfoImpl((Asn1)iterator2.next()));
        }
        int n = 0;
        while (iterator.hasNext()) {
            asn12 = (Asn1)iterator.next();
            int n2 = asn12.getTagNumber();
            if (n2 <= n) {
                throw new Asn1Exception("Sequence out of order");
            }
            n = n2;
            switch (n2) {
                case 1: {
                    this.nonce = ((Integer)asn12.components().next()).getInt();
                    break;
                }
                case 2: {
                    this.timestamp = ((GeneralizedTime)asn12.components().next()).getDate();
                    break;
                }
                case 3: {
                    this.usec = ((Integer)asn12.components().next()).getInt();
                    break;
                }
                case 4: {
                    this.sAddress = new HostAddress((Asn1)asn12.components().next()).getInetAddress();
                    break;
                }
                case 5: {
                    this.rAddress = new HostAddress((Asn1)asn12.components().next()).getInetAddress();
                    break;
                }
                default: {
                    throw new Asn1Exception("Invalid context tag number in sequence");
                }
            }
        }
    }

    EncKrbCredPart(Vector vector, int n, InetAddress inetAddress, InetAddress inetAddress2) {
        this.asn1 = new Explicit(64, 29);
        Sequence sequence = new Sequence();
        this.credsInfo = vector;
        Sequence sequence2 = new Sequence();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            sequence2.add(((KrbCredInfoImpl)iterator.next()).getAsn1());
        }
        Explicit explicit = new Explicit(128, 0);
        explicit.add(sequence2);
        sequence.add(explicit);
        this.nonce = n;
        if (n != -1) {
            explicit = new Explicit(128, 1);
            explicit.add(new Integer(n));
            sequence.add(explicit);
        }
        long l = System.currentTimeMillis();
        long l2 = l / 1000L * 1000L;
        this.timestamp = new Date(l2);
        explicit = new Explicit(128, 2);
        explicit.add(new GeneralizedTime(this.timestamp));
        sequence.add(explicit);
        this.usec = (int)((l - l2) * 1000L);
        explicit = new Explicit(128, 3);
        explicit.add(new Integer(this.usec));
        sequence.add(explicit);
        if (inetAddress != null) {
            this.sAddress = inetAddress;
            explicit = new Explicit(128, 4);
            explicit.add(new HostAddress(inetAddress).getAsn1());
            sequence.add(explicit);
        }
        if (inetAddress2 != null) {
            this.rAddress = inetAddress2;
            explicit = new Explicit(128, 5);
            explicit.add(new HostAddress(inetAddress2).getAsn1());
            sequence.add(explicit);
        }
        this.asn1.add(sequence);
    }

    byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    int getNonce() {
        return this.nonce;
    }

    InetAddress getReceiverAddress() {
        return this.rAddress;
    }

    InetAddress getSenderAddress() {
        return this.sAddress;
    }

    Vector getTicketInfo() {
        return this.credsInfo;
    }

    Date getTimestamp() {
        return new Date(this.timestamp.getTime() + (long)(this.usec / 1000));
    }
}

