/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionType;
import com.dstc.security.kerberos.HostAddress;
import com.dstc.security.kerberos.KDCOptions;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketImpl;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class KDCReqBody {
    private Asn1 asn1 = null;
    private KDCOptions kdcOptions = null;
    private PrincipalName cname = null;
    private String realm = null;
    private PrincipalName sname = null;
    private Date from = null;
    private Date till = null;
    private Date rtime = null;
    private int nonce = -1;
    private EncryptionType etype = null;
    private Vector addresses = null;
    private EncryptedDataImpl encAuthData = null;
    private Vector addTickets = null;

    KDCReqBody(Asn1 asn1) throws Asn1Exception, KerberosException {
        Iterator iterator;
        this.asn1 = asn1;
        Iterator iterator2 = asn1.components();
        Asn1 asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad tag number");
        }
        this.kdcOptions = new KDCOptions((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() == 1) {
            this.cname = new PrincipalName((Asn1)asn12.components().next());
            asn12 = (Asn1)iterator2.next();
        }
        this.realm = ((GeneralString)asn12.components().next()).getString();
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() == 3) {
            this.sname = new PrincipalName((Asn1)asn12.components().next());
            asn12 = (Asn1)iterator2.next();
        }
        if (asn12.getTagNumber() == 4) {
            this.from = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator2.next();
        }
        if (asn12.getTagNumber() == 5) {
            this.till = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator2.next();
        }
        if ((asn12 = (Asn1)iterator2.next()).getTagNumber() == 6) {
            this.rtime = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator2.next();
        }
        this.nonce = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator2.next();
        this.etype = new EncryptionType((Asn1)asn12.components().next());
        if (!iterator2.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() == 9) {
            iterator = ((Sequence)asn12.components().next()).components();
            this.addresses = new Vector();
            while (iterator.hasNext()) {
                this.addresses.add(new HostAddress((Asn1)iterator.next()).getInetAddress());
            }
            if (!iterator2.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator2.next();
        }
        if (asn12.getTagNumber() == 10) {
            this.encAuthData = new EncryptedDataImpl((Asn1)asn12.components().next());
            if (!iterator2.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator2.next();
        }
        iterator = ((Sequence)asn12.components().next()).components();
        this.addTickets = new Vector();
        while (iterator.hasNext()) {
            this.addTickets.add(new TicketImpl((Asn1)iterator.next()));
        }
    }

    KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, String string, PrincipalName principalName2, Date date, Date date2, Date date3, int n, EncryptionType encryptionType, Vector vector, EncryptedDataImpl encryptedDataImpl, Vector vector2) throws KerberosException {
        Iterator iterator;
        Sequence sequence;
        this.asn1 = new Sequence();
        if (kDCOptions == null) {
            throw new KerberosException("KDCOptions not set in KDCReqBody");
        }
        this.kdcOptions = kDCOptions;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(kDCOptions.getAsn1());
        this.asn1.add(explicit);
        if (principalName != null) {
            this.cname = principalName;
            explicit = new Explicit(128, 1);
            explicit.add(principalName.getAsn1());
            this.asn1.add(explicit);
        }
        if (string == null) {
            throw new KerberosException("Realm not set in KDCReqBody");
        }
        this.realm = string;
        explicit = new Explicit(128, 2);
        explicit.add(new GeneralString(string));
        this.asn1.add(explicit);
        if (principalName2 != null) {
            this.sname = principalName2;
            explicit = new Explicit(128, 3);
            explicit.add(principalName2.getAsn1());
            this.asn1.add(explicit);
        }
        if (date != null) {
            this.from = date;
            explicit = new Explicit(128, 4);
            explicit.add(new GeneralizedTime(date));
            this.asn1.add(explicit);
        }
        if (date2 != null) {
            this.till = date2;
            explicit = new Explicit(128, 5);
            explicit.add(new GeneralizedTime(date2));
            this.asn1.add(explicit);
        }
        if (date3 != null) {
            this.rtime = date3;
            explicit = new Explicit(128, 6);
            explicit.add(new GeneralizedTime(date3));
            this.asn1.add(explicit);
        }
        if (n == -1) {
            throw new KerberosException("Nonce not set in KDCReqBody");
        }
        this.nonce = n;
        explicit = new Explicit(128, 7);
        explicit.add(new Integer(n));
        this.asn1.add(explicit);
        if (encryptionType == null) {
            throw new KerberosException("Etype not set in KDCReqBody");
        }
        this.etype = encryptionType;
        explicit = new Explicit(128, 8);
        explicit.add(encryptionType.getAsn1());
        this.asn1.add(explicit);
        if (vector != null) {
            this.addresses = vector;
            explicit = new Explicit(128, 9);
            sequence = new Sequence();
            iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                sequence.add(new HostAddress((InetAddress)iterator.next()).getAsn1());
            }
            explicit.add(sequence);
            this.asn1.add(explicit);
        }
        if (encryptedDataImpl != null) {
            this.encAuthData = encryptedDataImpl;
            explicit = new Explicit(128, 10);
            explicit.add(encryptedDataImpl.getAsn1());
            this.asn1.add(explicit);
        }
        if (vector2 != null) {
            this.addTickets = vector2;
            sequence = new Sequence();
            try {
                iterator = ((AbstractList)vector2).iterator();
                while (iterator.hasNext()) {
                    sequence.add(new TicketImpl(((Ticket)iterator.next()).getEncoded()).getAsn1());
                }
            }
            catch (Asn1Exception asn1Exception) {
                throw new KerberosException(asn1Exception.getMessage());
            }
            explicit = new Explicit(128, 11);
            explicit.add(sequence);
            this.asn1.add(explicit);
        }
    }

    Vector getAdditionalTickets() {
        return this.addTickets;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    Vector getClientAddresses() {
        return this.addresses;
    }

    PrincipalName getClientName() {
        return this.cname;
    }

    EncryptedDataImpl getEncAuthData() {
        return this.encAuthData;
    }

    byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    EncryptionType getEncryptionType() {
        return this.etype;
    }

    Date getFrom() {
        return this.from;
    }

    int getNonce() {
        return this.nonce;
    }

    KDCOptions getOptions() {
        return this.kdcOptions;
    }

    String getRealm() {
        return this.realm;
    }

    Date getRenewTill() {
        return this.rtime;
    }

    PrincipalName getServerName() {
        return this.sname;
    }

    Date getTill() {
        return this.till;
    }
}

