/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.HostAddress;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.TicketFlags;
import com.dstc.security.kerberos.TicketFlagsImpl;
import com.dstc.security.kerberos.creds.Credential;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class KrbCredInfoImpl {
    private Asn1 asn1 = null;
    private EncryptionKeyImpl key = null;
    private String pRealm = null;
    private PrincipalName pName = null;
    private TicketFlagsImpl flags = null;
    private Date authTime = null;
    private Date startTime = null;
    private Date endTime = null;
    private Date renewTill = null;
    private String sRealm = null;
    private PrincipalName sName = null;
    private Vector caddr = null;

    KrbCredInfoImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad tag number");
        }
        this.key = new EncryptionKeyImpl((Asn1)asn12.components().next());
        int n = 0;
        block12: while (iterator.hasNext()) {
            asn12 = (Asn1)iterator.next();
            int n2 = asn12.getTagNumber();
            if (n2 <= n) {
                throw new Asn1Exception("Sequence out of order");
            }
            n = n2;
            switch (n2) {
                case 1: {
                    this.pRealm = ((GeneralString)asn12.components().next()).getString();
                    break;
                }
                case 2: {
                    this.pName = new PrincipalName((Asn1)asn12.components().next());
                    break;
                }
                case 3: {
                    this.flags = new TicketFlagsImpl((Asn1)asn12.components().next());
                    break;
                }
                case 4: {
                    this.authTime = ((GeneralizedTime)asn12.components().next()).getDate();
                    break;
                }
                case 5: {
                    this.startTime = ((GeneralizedTime)asn12.components().next()).getDate();
                    break;
                }
                case 6: {
                    this.endTime = ((GeneralizedTime)asn12.components().next()).getDate();
                    break;
                }
                case 7: {
                    this.renewTill = ((GeneralizedTime)asn12.components().next()).getDate();
                    break;
                }
                case 8: {
                    this.sRealm = ((GeneralString)asn12.components().next()).getString();
                    break;
                }
                case 9: {
                    this.sName = new PrincipalName((Asn1)asn12.components().next());
                    break;
                }
                case 10: {
                    Iterator iterator2 = ((Sequence)asn12.components().next()).components();
                    this.caddr = new Vector();
                    while (iterator2.hasNext()) {
                        this.caddr.add(new HostAddress((Asn1)iterator2.next()).getInetAddress());
                    }
                    continue block12;
                }
                default: {
                    throw new Asn1Exception("Invalid context tag number in sequence");
                }
            }
        }
    }

    KrbCredInfoImpl(EncryptionKey encryptionKey, String string, PrincipalName principalName, TicketFlags ticketFlags, Date date, Date date2, Date date3, Date date4, String string2, PrincipalName principalName2, InetAddress[] inetAddressArray) {
        this.asn1 = new Sequence();
        this.key = new EncryptionKeyImpl(encryptionKey.keyType(), encryptionKey.keyValue());
        Explicit explicit = new Explicit(128, 0);
        explicit.add(this.key.getAsn1());
        this.asn1.add(explicit);
        if (string != null) {
            this.pRealm = string;
            explicit = new Explicit(128, 1);
            explicit.add(new GeneralString(string));
            this.asn1.add(explicit);
        }
        if (principalName != null) {
            this.pName = new PrincipalName(principalName.nameType(), principalName.nameComponents());
            explicit = new Explicit(128, 2);
            explicit.add(this.pName.getAsn1());
            this.asn1.add(explicit);
        }
        if (ticketFlags != null) {
            this.flags = new TicketFlagsImpl(ticketFlags);
            explicit = new Explicit(128, 3);
            explicit.add(this.flags.getAsn1());
            this.asn1.add(explicit);
        }
        if (date != null) {
            this.authTime = date;
            explicit = new Explicit(128, 4);
            explicit.add(new GeneralizedTime(date));
            this.asn1.add(explicit);
        }
        if (date2 != null) {
            this.startTime = date2;
            explicit = new Explicit(128, 5);
            explicit.add(new GeneralizedTime(date2));
            this.asn1.add(explicit);
        }
        if (date3 != null) {
            this.endTime = date3;
            explicit = new Explicit(128, 6);
            explicit.add(new GeneralizedTime(date3));
            this.asn1.add(explicit);
        }
        if (date4 != null) {
            this.renewTill = date4;
            explicit = new Explicit(128, 7);
            explicit.add(new GeneralizedTime(date4));
            this.asn1.add(explicit);
        }
        if (string2 != null) {
            this.sRealm = string2;
            explicit = new Explicit(128, 8);
            explicit.add(new GeneralString(string2));
            this.asn1.add(explicit);
        }
        if (principalName2 != null) {
            this.sName = new PrincipalName(principalName2.nameType(), principalName2.nameComponents());
            explicit = new Explicit(128, 9);
            explicit.add(this.sName.getAsn1());
            this.asn1.add(explicit);
        }
        if (inetAddressArray != null) {
            this.caddr = new Vector();
            int n = 0;
            while (n < inetAddressArray.length) {
                this.caddr.add(inetAddressArray[n]);
                ++n;
            }
            explicit = new Explicit(128, 10);
            Sequence sequence = new Sequence();
            Iterator iterator = ((AbstractList)this.caddr).iterator();
            while (iterator.hasNext()) {
                sequence.add(new HostAddress((InetAddress)iterator.next()).getAsn1());
            }
            explicit.add(sequence);
            this.asn1.add(explicit);
        }
    }

    KrbCredInfoImpl(Credential credential) {
        this(credential.getSessionKey(), credential.getClientRealm(), credential.getClientName(), credential.getTicketFlags(), credential.getAuthTime(), credential.getStartTime(), credential.getEndTime(), credential.getRenewTill(), credential.getServerRealm(), credential.getServerName(), credential.getClientAddresses());
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    Date getAuthTime() {
        return this.authTime;
    }

    InetAddress[] getClientAddresses() {
        if (this.caddr == null) {
            return null;
        }
        InetAddress[] inetAddressArray = new InetAddress[this.caddr.size()];
        this.caddr.toArray(inetAddressArray);
        return inetAddressArray;
    }

    PrincipalName getClientName() {
        return this.pName;
    }

    String getClientRealm() {
        return this.pRealm;
    }

    Date getEndTime() {
        return this.endTime;
    }

    Date getRenewTill() {
        return this.renewTill;
    }

    PrincipalName getServerName() {
        return this.sName;
    }

    String getServerRealm() {
        return this.sRealm;
    }

    EncryptionKeyImpl getSessionKey() {
        return this.key;
    }

    Date getStartTime() {
        return this.startTime;
    }

    TicketFlagsImpl getTicketFlags() {
        return this.flags;
    }
}

