/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import java.util.Date;
import java.util.Iterator;

public class LastReqElement {
    public static final int NO_INFORMATION = 0;
    public static final int LAST_INITIAL_REQUEST_TGT = 1;
    public static final int LAST_INITIAL_REQUEST = 2;
    public static final int NEWEST_TGT = 3;
    public static final int LAST_RENEWABLE = 4;
    public static final int LAST_REQUEST = 5;
    private Asn1 asn1 = null;
    private int lrType;
    private Date lrValue;

    LastReqElement(int n, Date date) {
        this.asn1 = new Sequence();
        this.lrType = n;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(n));
        this.asn1.add(explicit);
        this.lrValue = date;
        explicit = new Explicit(128, 1);
        explicit.add(new GeneralizedTime(date));
        this.asn1.add(explicit);
    }

    LastReqElement(Asn1 asn1) {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.lrType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        this.lrValue = ((GeneralizedTime)asn12.components().next()).getDate();
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public String toString() {
        if (this.lrType == 0) {
            return "";
        }
        return "\n  [type: " + this.lrType + " time: " + this.lrValue + "]";
    }

    public int type() {
        return this.lrType;
    }

    public Date value() {
        return this.lrValue;
    }
}

