/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.util.Iterator;

final class TransitedEncoding {
    private Asn1 asn1 = null;
    private int trType;
    private byte[] trContents;

    TransitedEncoding(int n, byte[] byArray) {
        this.asn1 = new Sequence();
        this.trType = n;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(n));
        this.asn1.add(explicit);
        this.trContents = byArray;
        explicit = new Explicit(128, 1);
        explicit.add(new OctetString(byArray));
        this.asn1.add(explicit);
    }

    TransitedEncoding(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.trType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.trContents = ((OctetString)asn12.components().next()).getBytes();
    }

    String[] getAsStringArray() {
        return null;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }
}

