/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.creds.CredentialStore;
import com.dstc.security.kerberos.gssapi.GSSKrbException;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.GSSName;
import java.util.Arrays;
import java.util.HashSet;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

final class GSSCredential
implements org.ietf.jgss.GSSCredential {
    private static final int MSEC_PER_SEC = 1000;
    private org.ietf.jgss.GSSName name;
    private Oid mechanism;
    private long startTime;
    private int lifetime;
    private int usage;

    GSSCredential(org.ietf.jgss.GSSName gSSName, int n, Oid oid, int n2, Kerberos kerberos) throws GSSException {
        if (n2 < 0 || n2 > 2) {
            throw new GSSKrbException(5, 8);
        }
        this.usage = n2;
        if (oid != null && !oid.equals(GSSManager.KRB5)) {
            throw new GSSException(1);
        }
        this.mechanism = GSSManager.KRB5;
        if (gSSName == null) {
            CredentialStore credentialStore = kerberos.getContext().getCredentialStore();
            if (credentialStore == null) {
                throw new GSSException(13, -1, "kerberos credential store not set");
            }
            this.name = new GSSName(credentialStore.getDefaultUser(), GSSName.KRB5_NT_PRINCIPAL_NAME, kerberos);
        } else {
            if (!gSSName.getStringNameType().containedIn(GSSManager.TYPES)) {
                throw new GSSException(3);
            }
            this.name = !gSSName.isMN() ? gSSName.canonicalize(GSSManager.KRB5) : gSSName;
        }
        this.startTime = System.currentTimeMillis();
        this.lifetime = n;
    }

    public void add(org.ietf.jgss.GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        throw new GSSException(13);
    }

    public void dispose() throws GSSException {
    }

    public boolean equals(Object object) {
        block3: {
            if (object == null || !(object instanceof org.ietf.jgss.GSSCredential)) break block3;
            try {
                org.ietf.jgss.GSSCredential gSSCredential = (org.ietf.jgss.GSSCredential)object;
                if (this.getName().equals(gSSCredential.getName())) {
                    HashSet<Oid> hashSet = new HashSet<Oid>(Arrays.asList(this.getMechs()));
                    HashSet<Oid> hashSet2 = new HashSet<Oid>(Arrays.asList(gSSCredential.getMechs()));
                    return hashSet.equals(hashSet2);
                }
            }
            catch (GSSException gSSException) {}
        }
        return false;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{this.mechanism};
        return oidArray;
    }

    public org.ietf.jgss.GSSName getName() throws GSSException {
        return this.name;
    }

    public org.ietf.jgss.GSSName getName(Oid oid) throws GSSException {
        return this.name.canonicalize(oid);
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (!this.mechanism.equals(oid)) {
            throw new GSSException(1);
        }
        if (this.usage == 1) {
            throw new GSSException(5);
        }
        return this.getRemainingLifetime();
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (!this.mechanism.equals(oid)) {
            throw new GSSException(1);
        }
        if (this.usage == 2) {
            throw new GSSException(5);
        }
        return this.getRemainingLifetime();
    }

    public int getRemainingLifetime() throws GSSException {
        if (this.lifetime == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = (int)((this.startTime - System.currentTimeMillis()) / 1000L) + this.lifetime;
        return n < 0 ? 0 : n;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        if (!this.mechanism.equals(oid)) {
            throw new GSSException(1);
        }
        return this.usage;
    }

    public int hashCode() {
        try {
            HashSet<Oid> hashSet = new HashSet<Oid>(Arrays.asList(this.getMechs()));
            return this.getName().hashCode() ^ hashSet.hashCode();
        }
        catch (GSSException gSSException) {
            return 0;
        }
    }
}

