/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.common.PBEKeyDerivation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12KeyDerivation
implements PBEKeyDerivation {
    public byte[] generateKey(int n, MessageDigest messageDigest, Key key, AlgorithmParameterSpec algorithmParameterSpec, int n2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n3;
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Unrecognised Mode");
        }
        if (!key.getAlgorithm().startsWith("PBE")) {
            throw new InvalidKeyException("Not a PBE Key");
        }
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not PBE parameters");
        }
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
        int n4 = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
        int n5 = PKCS12KeyDerivation.getMessageDigestBlockSize(messageDigest);
        int n6 = PKCS12KeyDerivation.getMessageDigestOutputSize(messageDigest);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray3 = new byte[n5];
        int n7 = 0;
        while (n7 < byArray3.length) {
            byArray3[n7] = (byte)n;
            ++n7;
        }
        try {
            int n8;
            if (byArray2.length != 0) {
                n8 = n5 * (int)Math.ceil((double)byArray2.length / (double)n5);
                n3 = 0;
                while (n3 < n8 / byArray2.length) {
                    byteArrayOutputStream.write(byArray2);
                    ++n3;
                }
                byteArrayOutputStream.write(byArray2, 0, n8 % byArray2.length);
            }
            if (byArray.length != 0) {
                n8 = n5 * (int)Math.ceil((double)byArray.length / (double)n5);
                n3 = 0;
                while (n3 < n8 / byArray.length) {
                    byteArrayOutputStream.write(byArray);
                    ++n3;
                }
                byteArrayOutputStream.write(byArray, 0, n8 % byArray.length);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error: " + iOException.getMessage());
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        n3 = (int)Math.ceil((double)n2 / (double)n6);
        byte[] byArray5 = new byte[n5 * n6];
        int n9 = 0;
        while (n9 < n3) {
            byte[] byArray6;
            messageDigest.reset();
            messageDigest.update(byArray3);
            messageDigest.update(byArray4);
            int n10 = 1;
            while (n10 < n4) {
                byArray6 = messageDigest.digest();
                messageDigest.reset();
                messageDigest.update(byArray6);
                ++n10;
            }
            byArray6 = messageDigest.digest();
            byte[] byArray7 = new byte[n5];
            int n11 = 1;
            while (n11 <= n5 / n6) {
                System.arraycopy(byArray6, 0, byArray7, n6 * (n11 - 1), byArray6.length);
                ++n11;
            }
            System.arraycopy(byArray6, 0, byArray7, n5 / n6 * n6, n5 % n6);
            System.arraycopy(byArray7, 0, byArray5, n9 * n6, n6);
            BigInteger bigInteger = new BigInteger(1, byArray7);
            int n12 = 1;
            while (n12 < byArray4.length - 1) {
                byte[] byArray8 = new byte[n5];
                System.arraycopy(byArray4, n12 - 1, byArray8, 0, n5);
                BigInteger bigInteger2 = bigInteger.add(BigInteger.ONE).add(new BigInteger(1, byArray8));
                byArray8 = bigInteger2.toByteArray();
                System.arraycopy(byArray8, byArray8.length - n5, byArray4, n12 - 1, n5);
                n12 += n5;
            }
            ++n9;
        }
        byte[] byArray9 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray9, 0, n2);
        return byArray9;
    }

    private static int getMessageDigestBlockSize(MessageDigest messageDigest) {
        if (messageDigest.getAlgorithm().equals("SHA")) {
            return 64;
        }
        if (messageDigest.getAlgorithm().equals("MD5")) {
            return 64;
        }
        if (messageDigest.getAlgorithm().equals("MD2")) {
            return 64;
        }
        if (messageDigest.getAlgorithm().equals("RIPEMD160")) {
            return 64;
        }
        return 0;
    }

    private static int getMessageDigestOutputSize(MessageDigest messageDigest) {
        return messageDigest.getDigestLength();
    }
}

