/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Set;
import com.dstc.security.common.AttributeTypeAndValue;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class RDN {
    private Asn1 asn1 = null;
    private Vector rdnComponents = new Vector();

    public RDN(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            this.rdnComponents.add(new AttributeTypeAndValue(asn12));
        }
    }

    public RDN(String string) {
        this.asn1 = new Set();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = stringTokenizer.nextToken().trim();
        AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(string2, string3);
        this.rdnComponents.addElement(attributeTypeAndValue);
        this.asn1.add(attributeTypeAndValue.getAsn1());
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.rdnComponents.size()) {
            stringBuffer.append(((AttributeTypeAndValue)this.rdnComponents.elementAt(n)).getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    public AttributeTypeAndValue[] getTypeAndValue() {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[this.rdnComponents.size()];
        this.rdnComponents.toArray(attributeTypeAndValueArray);
        return attributeTypeAndValueArray;
    }
}

