/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BMPString;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.common.Attribute;
import com.dstc.security.common.FriendlyName;
import com.dstc.security.common.LocalKeyId;
import com.dstc.security.keymanage.PKCS8Exception;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs12.bags.Bag;
import com.dstc.security.keymanage.pkcs12.bags.CertBag;
import com.dstc.security.keymanage.pkcs12.bags.ShroudedKeyBag;
import com.dstc.security.keymanage.pkcs12.bags.UnknownBag;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SafeBag {
    public static final int KEYBAG = "1.2.840.113549.1.12.10.1.1".hashCode();
    public static final int SHROUDED_KEYBAG = "1.2.840.113549.1.12.10.1.2".hashCode();
    public static final int CERTBAG = "1.2.840.113549.1.12.10.1.3".hashCode();
    public static final int CRLBAG = "1.2.840.113549.1.12.10.1.4".hashCode();
    public static final int SECRETBAG = "1.2.840.113549.1.12.10.1.5".hashCode();
    public static final int SAFECONTENTBAG = "1.2.840.113549.1.12.10.1.6".hashCode();
    protected static final int TAG_EXPLICIT = 0;
    private Asn1 asn1;
    private String bagId;
    private Bag bag;
    private Vector bagAttributes;

    public SafeBag(Asn1 asn1) throws PKCS8Exception, Asn1Exception {
        Asn1 asn12;
        Object object;
        Asn1 asn13;
        Debug.dumpAsn1To(asn1, "safebag");
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            asn13 = (Oid)iterator.next();
            this.bagId = ((Oid)asn13).getOid();
            object = (Asn1)iterator.next();
            asn12 = (Asn1)((Asn1)object).components().next();
            int n = this.bagId.hashCode();
            this.bag = CERTBAG == n ? new CertBag(asn12) : (SHROUDED_KEYBAG == n ? new ShroudedKeyBag(asn12) : new UnknownBag(asn1));
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid SafeBag ASN.1");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete SafeBag ASN.1");
        }
        if (iterator.hasNext()) {
            this.bagAttributes = new Vector();
            asn13 = (Set)iterator.next();
            object = asn13.components();
            while (object.hasNext()) {
                asn12 = (Asn1)object.next();
                Attribute attribute = new Attribute(asn12);
                this.bagAttributes.add(attribute);
            }
        }
    }

    public SafeBag(Bag bag) {
        this(bag, null);
    }

    public SafeBag(Bag bag, Vector vector) {
        this(bag.getType(), bag, vector);
    }

    public SafeBag(String string, Bag bag) {
        this(string, bag, null);
    }

    public SafeBag(String string, Bag bag, Vector vector) {
        this.bagId = string;
        this.bag = bag;
        this.bagAttributes = vector;
        this.initialize();
    }

    public static Object createFriendlyName(String string) {
        FriendlyName friendlyName = null;
        try {
            friendlyName = new FriendlyName(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.log(5, "SafeBag.createFriendlyName()", "Unexpected exception: " + unsupportedEncodingException.toString());
            throw new RuntimeException("Unexpected exception: " + unsupportedEncodingException.toString());
        }
        return friendlyName;
    }

    public static Object createLocalKeyId(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.log(6, "SafeBag.createLocalKeyId()", "JCSI is not installed correctly: " + noSuchAlgorithmException.toString());
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        return new LocalKeyId(byArray2);
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    private byte[] getAttributeValue(String string) throws IOException {
        Iterator iterator = ((AbstractList)this.getBagAttributes()).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getType().equals(string)) continue;
            Vector vector = attribute.getValues();
            if (vector.size() != 1) {
                throw new IOException("Expecting Single Value Attribute");
            }
            if (string.equals("1.2.840.113549.1.9.20")) {
                return ((BMPString)vector.elementAt(0)).getValue();
            }
            return ((OctetString)vector.elementAt(0)).getBytes();
        }
        return null;
    }

    public Bag getBag() {
        return this.bag;
    }

    public int getBagAttributeSize() {
        if (this.bagAttributes == null) {
            return 0;
        }
        return this.bagAttributes.size();
    }

    public Vector getBagAttributes() {
        if (this.bagAttributes == null) {
            return new Vector();
        }
        return this.bagAttributes;
    }

    public String getBagId() {
        return this.bagId;
    }

    public String getFNAttribute() {
        try {
            byte[] byArray = this.getAttributeValue("1.2.840.113549.1.9.20");
            if (byArray != null) {
                return new String(byArray, "UnicodeBig");
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFriendlyName() {
        try {
            byte[] byArray = this.getAttributeValue("1.2.840.113549.1.9.20");
            if (byArray == null) {
                return ((X509Certificate)((CertBag)this.bag).getCertificate()).getSubjectDN().getName();
            }
            return new String(byArray, "UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getLocalKeyId() throws IOException {
        return this.getAttributeValue("1.2.840.113549.1.9.21");
    }

    private void initialize() {
        this.asn1 = new Sequence();
        Oid oid = new Oid(this.bagId);
        this.asn1.add(oid);
        Explicit explicit = new Explicit(128, 0);
        Asn1 asn1 = this.bag.getAsn1();
        explicit.add(asn1);
        this.asn1.add(explicit);
        if (this.bagAttributes != null) {
            Set set = new Set();
            Iterator iterator = ((AbstractList)this.bagAttributes).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                set.add(attribute.getAsn1());
            }
            this.asn1.add(set);
        }
    }

    protected static String printHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(SafeBag.toHexDigit(byArray[n]));
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void removeFN() {
        Iterator iterator = ((AbstractList)this.bagAttributes).iterator();
        Attribute attribute = null;
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getType().equals("1.2.840.113549.1.9.20")) continue;
            attribute = attribute2;
        }
        if (attribute != null) {
            this.bagAttributes.remove(attribute);
            this.initialize();
        }
    }

    private static String toHexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }
}

