/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs7;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.common.OID;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs7.AlgorithmId;
import com.dstc.security.keymanage.pkcs7.Content;
import com.dstc.security.keymanage.pkcs7.ContentInfo;
import com.dstc.security.keymanage.pkcs7.Data;
import com.dstc.security.keymanage.pkcs7.EncryptedContentInfo;
import com.dstc.security.keymanage.pkcs7.EncryptedData;
import com.dstc.security.keymanage.util.PKCS12KeyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class ContentInfoFactory {
    public static final String DEFAULT_ALGORITHM = "PBEwithMD5andDES-CBC";
    public static final String DEFAULT_ALGORITHM_OID = "1.2.840.113549.1.5.3";
    private static final int DATA = "1.2.840.113549.1.7.1".hashCode();
    private static final int ENCRYPTED_DATA = "1.2.840.113549.1.7.6".hashCode();
    private static final int ENVELOPED_DATA = "1.2.840.113549.1.7.3".hashCode();
    private static final int SIGNED_DATA = "1.2.840.113549.1.7.2".hashCode();

    public static ContentInfo createContentInfo(Asn1 asn1) {
        ContentInfo contentInfo = null;
        try {
            byte[] byArray = asn1.getEncoded();
            Data data = new Data(byArray);
            contentInfo = new ContentInfo("1.2.840.113549.1.7.1", data);
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("Unexpected exception: " + asn1Exception.toString());
        }
        return contentInfo;
    }

    public static byte[] decrypt(ContentInfo contentInfo, SecretKey secretKey) throws Asn1Exception, BadPaddingException, ClassNotFoundException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, IOException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (!contentInfo.getContentType().equals("1.2.840.113549.1.7.6")) {
            throw new Asn1Exception("ContentType not EncryptedData as expected");
        }
        EncryptedData encryptedData = null;
        try {
            encryptedData = (EncryptedData)contentInfo.getAsContent();
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Content Not EncryptedData As Expected");
        }
        EncryptedContentInfo encryptedContentInfo = encryptedData.getEncryptedContentInfo();
        return ContentInfoFactory.decrypt(encryptedContentInfo, secretKey);
    }

    public static ContentInfo decrypt(ContentInfo contentInfo, char[] cArray) throws Asn1Exception, BadPaddingException, ClassNotFoundException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, IOException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecretKey secretKey = PKCS12KeyFactory.createPBEKey(cArray);
        byte[] byArray = ContentInfoFactory.decrypt(contentInfo, secretKey);
        Asn1 asn1 = Asn1.getAsn1(byArray);
        Content content = ContentInfoFactory.resolve(contentInfo.getContentType(), asn1);
        return new ContentInfo(content);
    }

    public static byte[] decrypt(EncryptedContentInfo encryptedContentInfo, SecretKey secretKey) throws BadPaddingException, ClassNotFoundException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, IOException, NoSuchAlgorithmException, NoSuchPaddingException {
        String string = encryptedContentInfo.getContentType().getOid();
        byte[] byArray = encryptedContentInfo.getEncryptedContent();
        AlgorithmId algorithmId = encryptedContentInfo.getContentEncryptionAlgorithm();
        String string2 = OID.getAlgName(algorithmId.getOid());
        Cipher cipher = Cipher.getInstance(string2);
        Class<?> clazz = Class.forName("javax.crypto.spec.PBEParameterSpec");
        PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmId.getParams().getParameterSpec(clazz);
        cipher.init(2, (Key)secretKey, pBEParameterSpec, null);
        return cipher.doFinal(byArray);
    }

    public static ContentInfo encrypt(ContentInfo contentInfo, String string, char[] cArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidParameterSpecException, ClassNotFoundException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        OctetString octetString = (OctetString)((Object)contentInfo.getAsContent());
        byte[] byArray = octetString.getBytes();
        byte[] byArray2 = ContentInfoFactory.encrypt(byArray, string, cArray);
        AlgorithmId algorithmId = new AlgorithmId(DEFAULT_ALGORITHM_OID);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo("1.2.840.113549.1.7.1", algorithmId, byArray2);
        EncryptedData encryptedData = new EncryptedData(encryptedContentInfo);
        return new ContentInfo("1.2.840.113549.1.7.6", encryptedData);
    }

    private static EncryptedContentInfo encrypt(ContentInfo contentInfo, SecretKey secretKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        String string = secretKey.getAlgorithm();
        AlgorithmId algorithmId = ContentInfoFactory.getAlgorithmId(string);
        byte[] byArray = null;
        try {
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, secretKey);
            byte[] byArray2 = contentInfo.getAsContent().getAsn1().getValue();
            byArray = cipher.doFinal(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No Cipher matches Key: " + noSuchAlgorithmException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {}
        return new EncryptedContentInfo(contentInfo.getContentType(), algorithmId, byArray);
    }

    private static byte[] encrypt(byte[] byArray, String string, char[] cArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidParameterSpecException, ClassNotFoundException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKey secretKey = PKCS12KeyFactory.createPBEKey(cArray);
        byte[] byArray2 = "".getBytes();
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray2, 5);
        Cipher cipher = Cipher.getInstance(string);
        cipher.init(1, (Key)secretKey, pBEParameterSpec, null);
        return cipher.doFinal(byArray);
    }

    private static AlgorithmId getAlgorithmId(String string) {
        String string2 = OID.getAlgOid(string);
        return new AlgorithmId(string2);
    }

    private static byte[] getBytes(OctetString octetString) {
        byte[] byArray = octetString.getBytes();
        if (byArray == null && octetString.isConstructed()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator iterator = octetString.components();
            while (iterator.hasNext()) {
                OctetString octetString2 = (OctetString)iterator.next();
                byte[] byArray2 = ContentInfoFactory.getBytes(octetString2);
                byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private static byte[] getBytes2(OctetString octetString) {
        byte[] byArray;
        block2: {
            byArray = octetString.getBytes();
            if (byArray != null || !octetString.isConstructed()) break block2;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                octetString.writeValue(byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                byArray = null;
            }
        }
        return byArray;
    }

    public static byte[] recurse(ContentInfo contentInfo, SecretKey[] secretKeyArray, PrivateKey[] privateKeyArray) throws Asn1Exception, BadPaddingException, ClassNotFoundException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, IOException, NoSuchAlgorithmException, NoSuchPaddingException {
        byte[] byArray = null;
        int n = contentInfo.getContentType().hashCode();
        if (SIGNED_DATA == n) {
            throw new UnsupportedOperationException("SigendData support in progress");
        }
        if (ENCRYPTED_DATA == n) {
            Debug.log(1, "ContentInfoFactory.recurse(...)", "trying keys to unencrypt EncryptedContentInfo");
            int n2 = 0;
            while (n2 < secretKeyArray.length) {
                try {
                    Debug.log(1, "ContentInfoFactory.recurse(...)", "trying key");
                    byArray = ContentInfoFactory.decrypt(contentInfo, secretKeyArray[n2]);
                    Debug.log(1, "ContentInfoFactory.recurse(...)", "valid key");
                    break;
                }
                catch (InvalidKeyException invalidKeyException) {
                    Debug.log(1, "ContentInfoFactory.recurse(...)", "invalid key");
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unexpected error: " + exception.toString());
                }
                ++n2;
            }
            if (byArray == null) {
                throw new InvalidKeyException();
            }
        } else {
            if (ENVELOPED_DATA == n) {
                throw new RuntimeException("EnvelopedData Support In Development");
            }
            if (DATA == n) {
                Data data = (Data)contentInfo.getAsContent();
                byArray = data.getBytes();
            } else {
                throw new Asn1Exception("Unsupported ContentInfo Type");
            }
        }
        return byArray;
    }

    public static Content resolve(String string, Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new NullPointerException("Asn1 is null");
        }
        int n = string.hashCode();
        Content content = null;
        if (DATA == n) {
            try {
                OctetString octetString = (OctetString)asn1;
                byte[] byArray = ContentInfoFactory.getBytes(octetString);
                if (byArray == null) {
                    throw new Asn1Exception("Empty/Invalid OctetString");
                }
                content = new Data(byArray);
            }
            catch (ClassCastException classCastException) {}
        } else if (ENCRYPTED_DATA == n) {
            content = new EncryptedData(asn1);
        } else {
            if (ENVELOPED_DATA == n) {
                throw new UnsupportedOperationException("EnvelopedData support in progress");
            }
            if (SIGNED_DATA == n) {
                throw new UnsupportedOperationException("SignedData support in progress");
            }
            throw new Asn1Exception("Unknown Type");
        }
        return content;
    }
}

