/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.x509.Extensions;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class X509CRLEntry
extends java.security.cert.X509CRLEntry {
    protected Asn1 asn1 = null;
    protected BigInteger userCertificate;
    protected UTCTime revocationDate;
    protected Extensions crlExtns = null;

    public X509CRLEntry() {
    }

    public X509CRLEntry(Asn1 asn1) throws IOException, Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.userCertificate = ((Integer)asn12).getBigInteger();
        this.revocationDate = (UTCTime)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        this.crlExtns = new Extensions((Asn1)iterator.next());
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Set getCriticalExtensionOIDs() {
        return this.crlExtns.getCriticalOIDs();
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.toString());
        }
    }

    public byte[] getExtensionValue(String string) {
        return this.crlExtns.getValue(string);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.crlExtns.getNonCriticalOIDs();
    }

    public Date getRevocationDate() {
        return this.revocationDate.getDate();
    }

    public BigInteger getSerialNumber() {
        return this.userCertificate;
    }

    public boolean hasExtensions() {
        return this.crlExtns != null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Serial number  : ").append(this.getSerialNumber());
        stringBuffer.append(",  Revocation time: ").append(this.getRevocationDate());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

