/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.common.AttributeTypeAndValue;
import com.dstc.security.common.RDN;
import com.dstc.security.common.X500Name;
import com.dstc.security.x509.GeneralName;
import com.dstc.security.x509.extns.SubjectAltName;
import java.security.cert.X509Certificate;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class X509ExtensionUtil {
    public static final int DIGITAL_SIGNATURE = 0;
    public static final int NON_REPUDIATION = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int DATA_ENCIPHERMENT = 3;
    public static final int KEY_AGREEMENT = 4;
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int ENCIPHER_ONLY = 7;
    public static final int DECIPHER_ONLY = 8;
    public static final int RFC822_NAME = 1;

    public static String[] getEmailAddress(X509Certificate x509Certificate) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            AttributeTypeAndValue[] attributeTypeAndValueArray;
            Vector vector;
            Object object;
            Object object2;
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.17");
            if (byArray != null && (object2 = Asn1.getAsn1(byArray).getValue()) != null) {
                object = new SubjectAltName(Asn1.getAsn1(object2));
                vector = ((SubjectAltName)object).getNames();
                int n = 0;
                attributeTypeAndValueArray = ((AbstractList)vector).iterator();
                while (attributeTypeAndValueArray.hasNext()) {
                    GeneralName generalName = (GeneralName)attributeTypeAndValueArray.next();
                    if (generalName.getType() == 1) {
                        hashSet.add(generalName.getName());
                    }
                    ++n;
                }
            }
            if ((object2 = (Object)x509Certificate.getSubjectDN().getName()) != null) {
                object = new X500Name((String)object2);
                vector = ((X500Name)object).getRDNs();
                Iterator iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    attributeTypeAndValueArray = ((RDN)iterator.next()).getTypeAndValue();
                    int n = 0;
                    while (n < attributeTypeAndValueArray.length) {
                        if (attributeTypeAndValueArray[n].getType().equals("1.2.840.113549.1.9.1")) {
                            hashSet.add(attributeTypeAndValueArray[n].getValue());
                        }
                        ++n;
                    }
                }
            }
            object = new String[hashSet.size()];
            ((AbstractCollection)hashSet).toArray((T[])object);
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error in processing subAltName" + exception.toString());
        }
    }

    public static String[] getSubjectAltNames(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.17");
        if (byArray == null) {
            return null;
        }
        try {
            byte[] byArray2 = Asn1.getAsn1(byArray).getValue();
            SubjectAltName subjectAltName = new SubjectAltName(Asn1.getAsn1(byArray2));
            Vector vector = subjectAltName.getNames();
            String[] stringArray = new String[vector.size()];
            int n = 0;
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                stringArray[n] = ((GeneralName)iterator.next()).getName();
                ++n;
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error in processing subAltName" + exception.toString());
        }
    }

    public static boolean isCACert(X509Certificate x509Certificate) {
        if (x509Certificate.getVersion() == 3) {
            return x509Certificate.getBasicConstraints() != -1;
        }
        return x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN());
    }

    public static boolean isDiffieHellmanKeyXCert(X509Certificate x509Certificate) {
        String string = x509Certificate.getPublicKey().getAlgorithm();
        return string.equals("DH") || string.equals("Diffie-Hellman");
    }

    public static boolean isIssuerNamePopulated(X509Certificate x509Certificate) {
        return x509Certificate.getIssuerDN() != null;
    }

    public static boolean isKeyUsageDecryption(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            return true;
        }
        if (blArray.length < 3) {
            return false;
        }
        if (blArray.length < 4) {
            return blArray[2];
        }
        return (blArray.length < 8 ? true : blArray[7] ^ true) && (blArray[2] || blArray[3]);
    }

    public static boolean isKeyUsageEncryption(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            return true;
        }
        if (blArray.length < 3) {
            return false;
        }
        if (blArray.length < 4) {
            return blArray[2];
        }
        return (blArray.length < 9 ? true : blArray[8] ^ true) && (blArray[2] || blArray[3]);
    }

    public static boolean isKeyUsageKeyAgreement(X509Certificate x509Certificate) {
        if (x509Certificate.getKeyUsage() == null) {
            return true;
        }
        return x509Certificate.getKeyUsage()[4];
    }

    public static boolean isKeyUsageSigning(X509Certificate x509Certificate) {
        if (x509Certificate.getKeyUsage() == null) {
            return true;
        }
        return x509Certificate.getKeyUsage()[0];
    }

    public static boolean isSubjectNamePopulated(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN() != null;
    }
}

