/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;
import java.util.Iterator;

public class BasicConstraints
implements ExtensionValue {
    private int len = -1;
    private boolean isCA;
    private Asn1 asn1;

    public BasicConstraints(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        if (!(asn1 instanceof Sequence)) {
            throw new Asn1Exception("Bad encoding for basic constraint");
        }
        Iterator iterator = asn1.components();
        if (!iterator.hasNext()) {
            return;
        }
        this.isCA = ((Boolean)iterator.next()).isTrue();
        if (!iterator.hasNext()) {
            return;
        }
        this.len = ((Integer)iterator.next()).getInt();
    }

    public BasicConstraints(boolean bl, int n) {
        this.asn1 = new Sequence();
        this.isCA = bl;
        if (bl) {
            this.asn1.add(new Boolean(1));
            this.len = n;
            if (n > -1) {
                this.asn1.add(new Integer(n));
            }
        }
    }

    public int getBasicConstraints() {
        return this.isCA ? this.len : -1;
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BasicConstraints extension:\n");
        stringBuffer.append("  CA: ");
        if (this.isCA) {
            stringBuffer.append(" true, ");
        } else {
            stringBuffer.append(" false, ");
        }
        stringBuffer.append("path length constraint = ");
        if (this.len > 0) {
            stringBuffer.append(String.valueOf(this.len) + "\n");
        } else {
            stringBuffer.append("unspecified\n");
        }
        return stringBuffer.toString();
    }
}

