/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.ExtensionValue;
import com.dstc.security.x509.extns.GeneralSubtrees;
import java.io.IOException;
import java.util.Iterator;

public class NameConstraints
implements ExtensionValue {
    private Asn1 asn1 = null;
    private GeneralSubtrees permittedSubtrees = null;
    private GeneralSubtrees excludedSubtrees = null;
    private final int PERMITTED_ASN1_TAG = 0;
    private final int EXCLUDED_ASN1_TAG = 1;

    public NameConstraints(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        if (!iterator.hasNext()) {
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.permittedSubtrees = new GeneralSubtrees(asn12);
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 1) {
            this.excludedSubtrees = new GeneralSubtrees(asn12);
            if (!iterator.hasNext()) {
                return;
            }
        }
        throw new Asn1Exception("Unknown NameConstraints certificate extension structure");
    }

    public NameConstraints(GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) throws IOException {
        Asn1 asn1;
        this.asn1 = new Sequence();
        this.permittedSubtrees = generalSubtrees;
        if (generalSubtrees != null) {
            asn1 = generalSubtrees.getAsn1();
            asn1.setTagClass(128);
            asn1.setTagNumber(0);
            this.asn1.add(asn1);
        }
        this.excludedSubtrees = generalSubtrees2;
        if (generalSubtrees2 != null) {
            asn1 = generalSubtrees2.getAsn1();
            asn1.setTagClass(128);
            asn1.setTagNumber(1);
            this.asn1.add(asn1);
        }
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public GeneralSubtrees getExcludedSubtrees() {
        return this.excludedSubtrees;
    }

    public GeneralSubtrees getPermittedSubtrees() {
        return this.permittedSubtrees;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name Constraints extension:\n");
        if (this.permittedSubtrees != null) {
            stringBuffer.append("  Permitted:  " + this.permittedSubtrees.toString() + "\n");
        }
        if (this.excludedSubtrees != null) {
            stringBuffer.append("  Excluded:  " + this.excludedSubtrees.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

