/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.DecryptionException;
import com.dstc.security.kerberos.EncAPRepPart;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.NotYetDecryptedException;
import com.dstc.security.kerberos.msg.APRep;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;

final class APRepImpl
implements APRep {
    private Asn1 asn1 = null;
    private int pvno = 5;
    private int msgType = 15;
    private EncryptedDataImpl encPart = null;
    private KerberosCipher cipher;
    private EncAPRepPart encAPRepPart;
    private Date clientTime = null;
    private int cusec = 0;
    private int seqNum = -1;
    private EncryptionKeyImpl subKey = null;
    private boolean decryptedOK = false;

    APRepImpl(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        if (this.asn1.getTagNumber() != 15) {
            throw new KerberosException("Wrong tag for an APRep");
        }
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != this.pvno) {
            throw new KerberosException("Not version 5");
        }
        asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != this.msgType) {
            throw new KerberosException("Wrong msgType for an APRep");
        }
        asn12 = (Asn1)iterator.next();
        this.encPart = new EncryptedDataImpl((Asn1)asn12.components().next());
    }

    APRepImpl(EncryptionKey encryptionKey, SecureRandom secureRandom) throws KerberosException {
        this.cipher = KerberosCipher.getInstance(encryptionKey.keyType(), null);
        this.cipher.initEncrypt(encryptionKey, secureRandom);
    }

    APRepImpl(byte[] byArray) throws Asn1Exception, KerberosException {
        this(Asn1.getAsn1(byArray));
    }

    public void decrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new DecryptionException("Cipher not yet set");
        }
        try {
            this.encAPRepPart = new EncAPRepPart(Asn1.getAsn1(this.cipher.decrypt(this.encPart)));
            this.decryptedOK = true;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        this.seqNum = this.encAPRepPart.getSequenceNumber();
        this.clientTime = this.encAPRepPart.getClientTime();
        this.cusec = this.encAPRepPart.getCusec();
        this.subKey = this.encAPRepPart.getEncryptionKey();
    }

    private void encode() {
        this.asn1 = new Explicit(64, this.msgType);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(this.pvno));
        sequence.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new Integer(this.msgType));
        sequence.add(explicit);
        explicit = new Explicit(128, 2);
        explicit.add(this.encPart.getAsn1());
        sequence.add(explicit);
        this.asn1.add(sequence);
    }

    void encrypt() throws KerberosException {
        if (this.clientTime == null) {
            throw new KerberosException("client time not yet set");
        }
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encAPRepPart = new EncAPRepPart(this.clientTime, this.cusec, this.subKey, this.seqNum);
        try {
            this.encPart = new EncryptedDataImpl(this.cipher.encrypt(this.encAPRepPart.getAsn1().getEncoded()));
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        this.encode();
    }

    public int encryptionType() {
        return this.encPart.getEncryptionType();
    }

    public Date getClientTime() throws NotYetDecryptedException {
        if (this.encAPRepPart == null) {
            throw new NotYetDecryptedException("APRep not yet decrypted");
        }
        return this.clientTime;
    }

    public int getCusec() throws NotYetDecryptedException {
        if (this.encAPRepPart == null) {
            throw new NotYetDecryptedException("APRep not yet decrypted");
        }
        return this.cusec;
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int getSequenceNumber() throws NotYetDecryptedException {
        if (this.encAPRepPart == null) {
            throw new NotYetDecryptedException("APRep not yet decrypted");
        }
        return this.seqNum;
    }

    public EncryptionKey getSubSessionKey() throws NotYetDecryptedException {
        if (this.encAPRepPart == null) {
            throw new NotYetDecryptedException("APRep not yet decrypted");
        }
        return this.subKey;
    }

    public void initDecrypt(EncryptionKey encryptionKey) throws KerberosException {
        if (encryptionKey == null) {
            throw new KerberosException("key is null");
        }
        int n = this.encPart.getEncryptionType();
        if (!KerberosCipher.checkEncType(n, encryptionKey.keyType())) {
            throw new KerberosException("key type mismatch");
        }
        this.cipher = KerberosCipher.getInstance(n, null);
        this.cipher.initDecrypt(encryptionKey, null);
    }

    void setClientTime(Date date, int n) {
        this.clientTime = date;
        this.cusec = n;
    }

    void setSequenceNumber(int n) {
        this.seqNum = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n++++ KRB-AP-REP Message ++++");
        stringBuffer.append("\nencryption type: " + this.encryptionType());
        if (this.encAPRepPart != null && this.decryptedOK) {
            stringBuffer.append(" (DECRYPTED OK)");
        }
        try {
            if (this.getSequenceNumber() != -1) {
                stringBuffer.append("\nsequence number: " + this.getSequenceNumber());
            }
            stringBuffer.append("\nsub session key: " + this.getSubSessionKey());
            stringBuffer.append("\nclient time: " + this.getClientTime());
            stringBuffer.append("\ncusec: " + this.getCusec());
        }
        catch (NotYetDecryptedException notYetDecryptedException) {}
        stringBuffer.append("\n++++++++++++++++++++++++++++");
        return stringBuffer.toString();
    }
}

