/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.AuthDataElement;
import com.dstc.security.kerberos.AuthorizationDataElement;
import com.dstc.security.kerberos.Checksum;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PrincipalName;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class Authenticator {
    public static final int TAG_KRB_AUTHENTICATOR = 2;
    private static final int pvno = 5;
    private Asn1 asn1 = null;
    private String crealm;
    private PrincipalName cName;
    private Checksum cksum;
    private int cusec;
    private Date ctime;
    private EncryptionKey subkey;
    private int seqNum = -1;
    private Vector authData;

    Authenticator(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        if (asn1.getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag Number");
        }
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        if (((Integer)asn12.components().next()).getInt() != 5) {
            throw new KerberosException("Not version 5");
        }
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.crealm = ((GeneralString)asn12.components().next()).getString();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cName = new PrincipalName((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 3) {
            this.cksum = new Checksum((Asn1)asn12.components().next());
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() != 4) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cusec = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 5) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.ctime = ((GeneralizedTime)asn12.components().next()).getDate();
        int n = 5;
        block5: while (iterator.hasNext()) {
            asn12 = (Asn1)iterator.next();
            int n2 = asn12.getTagNumber();
            if (n2 <= n) {
                throw new Asn1Exception("Sequence out of order");
            }
            n = n2;
            switch (n2) {
                case 6: {
                    this.subkey = new EncryptionKeyImpl((Asn1)asn12.components().next());
                    break;
                }
                case 7: {
                    this.seqNum = ((Integer)asn12.components().next()).getInt();
                    break;
                }
                case 8: {
                    this.authData = new Vector();
                    Iterator iterator2 = ((Sequence)asn12.components().next()).components();
                    while (iterator2.hasNext()) {
                        this.authData.add(new AuthDataElement((Asn1)iterator2.next()));
                    }
                    continue block5;
                }
                default: {
                    throw new Asn1Exception("Invalid context tag number in sequence");
                }
            }
        }
    }

    Authenticator(String string, PrincipalName principalName, Checksum checksum, Date date, EncryptionKey encryptionKey, int n, Vector vector) {
        this.asn1 = new Explicit(64, 2);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(5));
        sequence.add(explicit);
        this.crealm = string;
        explicit = new Explicit(128, 1);
        explicit.add(new GeneralString(string));
        sequence.add(explicit);
        this.cName = principalName;
        explicit = new Explicit(128, 2);
        explicit.add(principalName.getAsn1());
        sequence.add(explicit);
        if (checksum != null) {
            this.cksum = checksum;
            explicit = new Explicit(128, 3);
            explicit.add(checksum.getAsn1());
            sequence.add(explicit);
        }
        long l = date.getTime();
        long l2 = l / 1000L * 1000L;
        this.cusec = (int)((l - l2) * 1000L);
        explicit = new Explicit(128, 4);
        explicit.add(new Integer(this.cusec));
        sequence.add(explicit);
        this.ctime = new Date(l2);
        explicit = new Explicit(128, 5);
        explicit.add(new GeneralizedTime(date));
        sequence.add(explicit);
        if (encryptionKey != null) {
            this.subkey = encryptionKey;
            explicit = new Explicit(128, 6);
            explicit.add(new EncryptionKeyImpl(encryptionKey.keyType(), encryptionKey.keyValue()).getAsn1());
            sequence.add(explicit);
        }
        if (n >= 0) {
            this.seqNum = n;
            explicit = new Explicit(128, 7);
            explicit.add(new Integer(n));
            sequence.add(explicit);
        }
        if (vector != null) {
            this.authData = vector;
            explicit = new Explicit(128, 8);
            Sequence sequence2 = new Sequence();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                AuthorizationDataElement authorizationDataElement = (AuthorizationDataElement)iterator.next();
                sequence2.add(new AuthDataElement(authorizationDataElement.type(), authorizationDataElement.data()).getAsn1());
            }
            explicit.add(sequence2);
            sequence.add(explicit);
        }
        this.asn1.add(sequence);
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    Vector getAuthData() {
        return this.authData;
    }

    Date getCTime() {
        return new Date(this.ctime.getTime() + (long)(this.cusec / 1000));
    }

    Checksum getChecksum() {
        return this.cksum;
    }

    PrincipalName getClientName() {
        return this.cName;
    }

    int getCusec() {
        return this.cusec;
    }

    String getRealm() {
        return this.crealm;
    }

    int getSeqNumber() {
        return this.seqNum;
    }

    EncryptionKey getSubKey() {
        return this.subkey;
    }
}

