/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketFlags;
import com.dstc.security.kerberos.TicketFlagsImpl;
import com.dstc.security.kerberos.TicketImpl;
import com.dstc.security.kerberos.creds.Credential;
import java.net.InetAddress;
import java.util.Date;

class CredentialImpl
implements Credential {
    private static final int CLOCK_SKEW = 300000;
    private byte[] authData;
    private TicketImpl ticket;
    private EncryptionKeyImpl key;
    private String clientRealm;
    private PrincipalName clientName;
    private Date authtime;
    private Date starttime;
    private Date endtime;
    private Date renewTill;
    private String serverRealm;
    private PrincipalName serverName;
    private InetAddress[] adds;
    private TicketFlagsImpl ticketFlags;

    CredentialImpl(TicketImpl ticketImpl, EncryptionKeyImpl encryptionKeyImpl, String string, PrincipalName principalName, String string2, PrincipalName principalName2, InetAddress[] inetAddressArray, TicketFlagsImpl ticketFlagsImpl, Date date, Date date2, Date date3, Date date4) {
        this.ticket = ticketImpl;
        this.key = encryptionKeyImpl;
        this.clientRealm = string;
        this.clientName = principalName;
        this.serverRealm = string2;
        this.serverName = principalName2;
        this.adds = inetAddressArray;
        this.ticketFlags = ticketFlagsImpl;
        this.authtime = date;
        this.starttime = date2;
        this.endtime = date3;
        this.renewTill = date4;
    }

    public byte[] getAuthData() {
        return this.authData;
    }

    public Date getAuthTime() {
        return this.authtime;
    }

    public InetAddress[] getClientAddresses() {
        return this.adds;
    }

    public PrincipalName getClientName() {
        return this.clientName;
    }

    public String getClientRealm() {
        return this.clientRealm;
    }

    public Date getEndTime() {
        return this.endtime;
    }

    public Date getRenewTill() {
        return this.renewTill;
    }

    public byte getSKey() {
        return 0;
    }

    public PrincipalName getServerName() {
        return this.serverName;
    }

    public String getServerRealm() {
        return this.serverRealm;
    }

    public EncryptionKey getSessionKey() {
        return this.key;
    }

    public Date getStartTime() {
        return this.starttime;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketFlags getTicketFlags() {
        return this.ticketFlags;
    }

    public boolean isValid() {
        long l = System.currentTimeMillis();
        long l2 = this.starttime != null ? this.starttime.getTime() : this.authtime.getTime();
        long l3 = this.endtime.getTime();
        if (l2 > l + 300000L) {
            return false;
        }
        return l3 >= l - 300000L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nCredential");
        stringBuffer.append("\nclient: " + this.getClientName() + "@" + this.getClientRealm());
        stringBuffer.append("\nsession key: " + this.getSessionKey());
        stringBuffer.append("\nservice principal: " + this.getServerName() + "@" + this.getServerRealm());
        stringBuffer.append("\nvalid from: " + (this.getStartTime() == null ? this.getAuthTime() : this.getStartTime()));
        stringBuffer.append("\nvalid till: " + this.getEndTime());
        if (this.getTicketFlags().renewable()) {
            stringBuffer.append("\nrenewable till: " + this.getRenewTill());
        }
        stringBuffer.append(this.getTicket());
        stringBuffer.append("\nticket flags: " + this.getTicketFlags());
        stringBuffer.append("\nvalid for:");
        InetAddress[] inetAddressArray = this.getClientAddresses();
        if (inetAddressArray != null) {
            int n = 0;
            while (n < inetAddressArray.length) {
                stringBuffer.append("\n  " + inetAddressArray[n]);
                ++n;
            }
        } else {
            stringBuffer.append(" all addresses");
        }
        return stringBuffer.toString();
    }
}

