/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.CCInputStream;
import com.dstc.security.kerberos.CCOutputStream;
import com.dstc.security.kerberos.CredentialImpl;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.HostAddress;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.TicketFlags;
import com.dstc.security.kerberos.TicketFlagsImpl;
import com.dstc.security.kerberos.TicketImpl;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.CredentialStore;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class FileCredentialStore
implements CredentialStore {
    static final byte[] KRB5_FCC_FVNO_2 = new byte[]{5, 2};
    static final byte[] KRB5_FCC_FVNO_3 = new byte[]{5, 3};
    static final byte[] KRB5_FCC_FVNO_4 = new byte[]{5, 4};
    private int version;
    private Hashtable creds = new Hashtable();
    private File file = null;
    private PrincipalName defName;
    private String defRealm;

    public synchronized Credential getCredential(String string) {
        return (Credential)this.creds.get(string);
    }

    public Iterator getCredentials() {
        return this.creds.values().iterator();
    }

    public synchronized String getDefaultRealm() {
        return this.defRealm;
    }

    public synchronized String getDefaultUser() {
        return this.defName == null ? null : this.defName.toString();
    }

    public Credential getTGTCredential(String string) {
        return this.getCredential("krbtgt/" + string + "@" + string);
    }

    public synchronized void load(File file) throws IOException {
        byte by;
        Hashtable<String, Credential> hashtable = new Hashtable<String, Credential>();
        FileInputStream fileInputStream = new FileInputStream(file);
        CCInputStream cCInputStream = new CCInputStream(fileInputStream);
        try {
            by = cCInputStream.readByte();
        }
        catch (EOFException eOFException) {
            return;
        }
        if (by != KRB5_FCC_FVNO_3[0]) {
            throw new IOException("Unsupported credential cache format: FVNO[0] = " + by);
        }
        by = cCInputStream.readByte();
        if (by == KRB5_FCC_FVNO_4[1]) {
            this.version = 4;
        } else if (by == KRB5_FCC_FVNO_3[1]) {
            this.version = 3;
        } else if (by == KRB5_FCC_FVNO_2[1]) {
            this.version = 2;
        } else {
            throw new IOException("Unsupported credential cache format: FVNO[1] = " + by);
        }
        if (this.version == 4) {
            cCInputStream.readShort();
        }
        this.readName(cCInputStream);
        while (fileInputStream.available() != 0) {
            Credential credential = FileCredentialStore.readCredential(cCInputStream, this.version);
            hashtable.put(String.valueOf(credential.getServerName().toString()) + "@" + credential.getServerRealm(), credential);
        }
        fileInputStream.close();
        this.creds = hashtable;
    }

    public synchronized void put(Credential credential) {
        this.creds.put(String.valueOf(String.valueOf(credential.getServerName())) + "@" + credential.getServerRealm(), credential);
    }

    private static Credential readCredential(CCInputStream cCInputStream, int n) throws IOException {
        int n2 = cCInputStream.readInt();
        int n3 = cCInputStream.readInt();
        String[] stringArray = new String[n3];
        String string = new String(cCInputStream.readBinaryString());
        int n4 = 0;
        while (n4 < n3) {
            stringArray[n4] = new String(cCInputStream.readBinaryString());
            ++n4;
        }
        PrincipalName principalName = new PrincipalName(n2, stringArray);
        n2 = cCInputStream.readInt();
        n3 = cCInputStream.readInt();
        stringArray = new String[n3];
        String string2 = new String(cCInputStream.readBinaryString());
        int n5 = 0;
        while (n5 < n3) {
            stringArray[n5] = new String(cCInputStream.readBinaryString());
            ++n5;
        }
        PrincipalName principalName2 = new PrincipalName(n2, stringArray);
        short s = cCInputStream.readShort();
        if (n == 3) {
            s = cCInputStream.readShort();
        }
        byte[] byArray = cCInputStream.readBinaryString();
        EncryptionKeyImpl encryptionKeyImpl = new EncryptionKeyImpl(s, byArray);
        Date date = new Date((long)cCInputStream.readInt() * 1000L);
        Date date2 = new Date((long)cCInputStream.readInt() * 1000L);
        Date date3 = new Date((long)cCInputStream.readInt() * 1000L);
        Date date4 = new Date((long)cCInputStream.readInt() * 1000L);
        byte by = cCInputStream.readByte();
        TicketFlagsImpl ticketFlagsImpl = new TicketFlagsImpl(cCInputStream.readInt());
        int n6 = cCInputStream.readInt();
        InetAddress[] inetAddressArray = new InetAddress[n6];
        if (n6 > 0) {
            int n7 = 0;
            while (n7 < n6) {
                cCInputStream.readShort();
                inetAddressArray[n7] = InetAddress.getByName(HostAddress.ipToString(cCInputStream.readBinaryString()));
                ++n7;
            }
        }
        byte[] byArray2 = cCInputStream.readBinaryString();
        byte[] byArray3 = cCInputStream.readBinaryString();
        TicketImpl ticketImpl = null;
        if (byArray3 != null && byArray3.length > 0) {
            try {
                ticketImpl = new TicketImpl(byArray3);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        byte[] byArray4 = cCInputStream.readBinaryString();
        TicketImpl ticketImpl2 = null;
        if (byArray4 != null && byArray4.length > 0) {
            try {
                ticketImpl2 = new TicketImpl(byArray4);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        return new CredentialImpl(ticketImpl, encryptionKeyImpl, string, principalName, string2, principalName2, inetAddressArray, ticketFlagsImpl, date, date2, date3, date4);
    }

    private void readName(CCInputStream cCInputStream) throws IOException {
        int n = cCInputStream.readInt();
        int n2 = cCInputStream.readInt();
        String[] stringArray = new String[n2];
        this.defRealm = new String(cCInputStream.readBinaryString());
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = new String(cCInputStream.readBinaryString());
            ++n3;
        }
        this.defName = new PrincipalName(n, stringArray);
    }

    public synchronized void save(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        CCOutputStream cCOutputStream = new CCOutputStream(fileOutputStream);
        cCOutputStream.writeByte(5);
        cCOutputStream.writeByte(3);
        FileCredentialStore.writeName(this.defName, this.defRealm, cCOutputStream);
        Enumeration enumeration = this.creds.elements();
        while (enumeration.hasMoreElements()) {
            FileCredentialStore.writeCredential((Credential)enumeration.nextElement(), cCOutputStream);
        }
        cCOutputStream.flush();
        fileOutputStream.close();
    }

    public synchronized void setDefaultUser(PrincipalName principalName, String string) {
        this.defName = principalName;
        this.defRealm = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getDefaultUser()) + "@" + this.getDefaultRealm());
        try {
            Iterator iterator = this.getCredentials();
            while (iterator.hasNext()) {
                stringBuffer.append((Credential)iterator.next());
                stringBuffer.append("\n");
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            stringBuffer.append("<interrupted>");
        }
        return stringBuffer.toString();
    }

    private static void writeCredential(Credential credential, CCOutputStream cCOutputStream) throws IOException {
        FileCredentialStore.writeName(credential.getClientName(), credential.getClientRealm(), cCOutputStream);
        FileCredentialStore.writeName(credential.getServerName(), credential.getServerRealm(), cCOutputStream);
        cCOutputStream.writeShort(credential.getSessionKey().keyType());
        cCOutputStream.writeShort(credential.getSessionKey().keyType());
        cCOutputStream.writeBinaryString(credential.getSessionKey().keyValue());
        Date date = credential.getAuthTime();
        if (date == null) {
            date = new Date(0L);
        }
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        date = credential.getStartTime();
        if (date == null) {
            date = new Date(0L);
        }
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        date = credential.getEndTime();
        if (date == null) {
            date = new Date(0L);
        }
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        date = credential.getRenewTill();
        if (date == null) {
            date = new Date(0L);
        }
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        int n = 0;
        cCOutputStream.writeByte(n);
        TicketFlags ticketFlags = credential.getTicketFlags();
        cCOutputStream.writeInt(ticketFlags.getIntMask());
        InetAddress[] inetAddressArray = credential.getClientAddresses();
        if (inetAddressArray == null) {
            cCOutputStream.writeInt(0);
        } else {
            cCOutputStream.writeInt(inetAddressArray.length);
            int n2 = 0;
            while (n2 < inetAddressArray.length) {
                cCOutputStream.writeShort(2);
                cCOutputStream.writeBinaryString(inetAddressArray[n2].getAddress());
                ++n2;
            }
        }
        byte[] byArray = credential.getAuthData();
        if (byArray != null) {
            cCOutputStream.writeBinaryString(byArray);
        } else {
            cCOutputStream.writeBinaryString(new byte[0]);
        }
        try {
            cCOutputStream.writeBinaryString(credential.getTicket().getEncoded());
        }
        catch (KerberosException kerberosException) {
            throw new IOException(kerberosException.getMessage());
        }
        cCOutputStream.writeBinaryString(new byte[0]);
    }

    private static void writeName(PrincipalName principalName, String string, CCOutputStream cCOutputStream) throws IOException {
        String[] stringArray = principalName.nameComponents();
        cCOutputStream.writeInt(principalName.nameType());
        cCOutputStream.writeInt(stringArray.length);
        cCOutputStream.writeBinaryString(string);
        int n = 0;
        while (n < stringArray.length) {
            cCOutputStream.writeBinaryString(stringArray[n]);
            ++n;
        }
    }
}

