/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.CCInputStream;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.creds.KeyTab;
import com.dstc.security.kerberos.creds.KeyTabEntry;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public final class FileKeyTab
implements KeyTab {
    private Hashtable entries = new Hashtable();
    private String fileName;
    private String defaultUser;

    public Iterator getKeyTabEntries() {
        return this.entries.values().iterator();
    }

    public KeyTabEntry getKeyTabEntry(String string) {
        return (KeyTabEntry)this.entries.get(string);
    }

    public String getKeyTabType() {
        return "MIT";
    }

    /*
     * Unable to fully structure code
     */
    public void load(File var1_1) throws IOException {
        var2_2 = new Hashtable<K, V>();
        var3_3 = new FileInputStream(var1_1);
        var4_4 = new CCInputStream(var3_3);
        try {
            var4_4.readShort();
            if (true) ** GOTO lbl16
        }
        catch (EOFException v0) {
            return;
        }
        do {
            var5_5 = var4_4.readInt();
            var6_6 = new byte[var5_5];
            var4_4.readFully(var6_6);
            var7_7 = new CCInputStream(new ByteArrayInputStream(var6_6));
            this.readEntry(var7_7, var2_2);
lbl16:
            // 2 sources

        } while (var4_4.available() != 0);
        this.entries = var2_2;
    }

    private void readEntry(CCInputStream cCInputStream, Hashtable hashtable) throws IOException {
        FileKeyTabEntry fileKeyTabEntry = new FileKeyTabEntry(cCInputStream);
        hashtable.put(fileKeyTabEntry.getPrincipalName(), fileKeyTabEntry);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n");
            stringBuffer.append(((KeyTabEntry)enumeration.nextElement()).toString());
        }
        return stringBuffer.toString();
    }

    static class FileKeyTabEntry
    implements KeyTabEntry {
        private String realm;
        private PrincipalName name;
        private Date timestamp;
        private int kvno;
        private int keyType;
        private byte[] key;

        public FileKeyTabEntry(CCInputStream cCInputStream) throws IOException {
            this.readName(cCInputStream);
            this.timestamp = new Date((long)cCInputStream.readInt() * 1000L);
            this.kvno = cCInputStream.readByte();
            this.keyType = cCInputStream.readShort();
            this.key = new byte[cCInputStream.readShort()];
            cCInputStream.readFully(this.key);
        }

        public String getPrincipalName() {
            return String.valueOf(this.name.toString()) + "@" + this.realm;
        }

        public int keyType() {
            return this.keyType;
        }

        public byte[] keyValue() {
            return (byte[])this.key.clone();
        }

        private void readName(CCInputStream cCInputStream) throws IOException {
            int n = cCInputStream.readShort();
            byte[] byArray = new byte[cCInputStream.readShort()];
            cCInputStream.readFully(byArray);
            this.realm = new String(byArray);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray2 = new byte[cCInputStream.readShort()];
                cCInputStream.readFully(byArray2);
                stringArray[n2] = new String(byArray2);
                ++n2;
            }
            int n3 = cCInputStream.readInt();
            this.name = new PrincipalName(n3, stringArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nPrincipal: ").append(this.name).append("@").append(this.realm);
            stringBuffer.append("\nTimeStamp: ").append(this.timestamp);
            stringBuffer.append("\nKVNO: ").append(this.kvno);
            stringBuffer.append("\nKey: [").append(this.keyType).append(",  ");
            int n = 0;
            while (n < this.key.length) {
                stringBuffer.append(String.valueOf(Integer.toHexString(this.key[n] & 0xFF)) + " ");
                ++n;
            }
            stringBuffer.append("]");
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

