/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.CredentialImpl;
import com.dstc.security.kerberos.EncKDCRepPart;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.LastReqElement;
import com.dstc.security.kerberos.NotYetDecryptedException;
import com.dstc.security.kerberos.PaData;
import com.dstc.security.kerberos.PaDataImpl;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketFlags;
import com.dstc.security.kerberos.TicketFlagsImpl;
import com.dstc.security.kerberos.TicketImpl;
import com.dstc.security.kerberos.creds.Credential;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

class KDCRepImpl {
    private Asn1 asn1 = null;
    private SecureRandom rand;
    private KerberosCipher cipher;
    private EncryptionKeyImpl targetKey;
    private int pvno = 5;
    private int msgType;
    private Vector paDatas;
    private String crealm;
    private PrincipalName cname;
    private TicketImpl ticket;
    private EncryptedDataImpl encPart;
    private EncKDCRepPart encKDCRepPart;
    private EncryptionKeyImpl sessionKey;
    private Vector lastReq;
    private int nonce;
    private Date keyExp;
    private TicketFlagsImpl flags;
    private Date authtime;
    private Date starttime;
    private Date endtime;
    private Date renewTill;
    private String srealm;
    private PrincipalName sname;
    private Vector adds;
    private boolean decryptedOK = false;

    KDCRepImpl(int n) {
        this.msgType = n;
    }

    KDCRepImpl(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        Asn1 asn12 = (Asn1)asn1.components().next();
        Iterator iterator = asn12.components();
        Asn1 asn13 = (Asn1)iterator.next();
        if (((Integer)asn13.components().next()).getInt() != this.pvno) {
            throw new KerberosException("Not version 5");
        }
        asn13 = (Asn1)iterator.next();
        this.msgType = ((Integer)asn13.components().next()).getInt();
        asn13 = (Asn1)iterator.next();
        if (asn13.getTagNumber() == 2) {
            this.paDatas = new Vector();
            Iterator iterator2 = ((Sequence)asn13.components().next()).components();
            while (iterator2.hasNext()) {
                this.paDatas.add(new PaDataImpl((Asn1)iterator2.next()));
            }
            asn13 = (Asn1)iterator.next();
        }
        this.crealm = ((GeneralString)asn13.components().next()).getString();
        asn13 = (Asn1)iterator.next();
        this.cname = new PrincipalName((Asn1)asn13.components().next());
        asn13 = (Asn1)iterator.next();
        this.ticket = new TicketImpl((Asn1)asn13.components().next());
        asn13 = (Asn1)iterator.next();
        this.encPart = new EncryptedDataImpl((Asn1)asn13.components().next());
    }

    KDCRepImpl(EncryptionKeyImpl encryptionKeyImpl, SecureRandom secureRandom) throws KerberosException {
        this.rand = secureRandom;
        this.cipher = KerberosCipher.getInstance(encryptionKeyImpl.keyType(), null);
        this.cipher.initEncrypt(encryptionKeyImpl, secureRandom);
        this.sessionKey = new EncryptionKeyImpl(1, "hellollo".getBytes());
        this.authtime = new Date();
        this.endtime = new Date(8L);
    }

    void addAddress(String string) {
        this.adds.add(string);
    }

    void addPadata(PaDataImpl paDataImpl) {
        this.paDatas.add(paDataImpl);
    }

    public void decrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        byte[] byArray = this.cipher.decrypt(this.encPart);
        try {
            Asn1 asn1 = Asn1.getAsn1(byArray);
            this.encKDCRepPart = new EncKDCRepPart((Asn1)asn1.components().next());
            this.decryptedOK = true;
            this.nonce = this.encKDCRepPart.getNonce();
            this.authtime = this.encKDCRepPart.getAuthTime();
            this.starttime = this.encKDCRepPart.getStartTime();
            this.endtime = this.encKDCRepPart.getEndTime();
            this.renewTill = this.encKDCRepPart.getRenewTill();
            this.keyExp = this.encKDCRepPart.getKeyExpiryTime();
            this.sessionKey = this.encKDCRepPart.getEncryptionKey();
            this.srealm = this.encKDCRepPart.getServerRealm();
            this.sname = this.encKDCRepPart.getServerName();
            this.flags = this.encKDCRepPart.getTicketFlags();
            this.adds = this.encKDCRepPart.getClientAddresses();
            this.lastReq = this.encKDCRepPart.getLastReq();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    private void encode() {
        this.asn1 = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(this.pvno));
        this.asn1.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new Integer(this.msgType));
        this.asn1.add(explicit);
        if (this.paDatas != null) {
            Iterator iterator = ((AbstractList)this.paDatas).iterator();
            Sequence sequence = new Sequence();
            while (iterator.hasNext()) {
                sequence.add(((PaDataImpl)iterator.next()).getAsn1());
            }
            explicit = new Explicit(128, 2);
            explicit.add(sequence);
            this.asn1.add(explicit);
        }
        explicit = new Explicit(128, 3);
        explicit.add(new GeneralString(this.crealm));
        this.asn1.add(explicit);
        explicit = new Explicit(128, 4);
        explicit.add(this.cname.getAsn1());
        this.asn1.add(explicit);
        explicit = new Explicit(128, 5);
        explicit.add(this.ticket.getAsn1());
        this.asn1.add(explicit);
        explicit = new Explicit(128, 6);
        explicit.add(this.encPart.getAsn1());
        this.asn1.add(explicit);
    }

    void encrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.ticket = new TicketImpl(this.targetKey, this.rand);
        this.ticket.encrypt();
    }

    public int encryptionType() {
        return this.encPart.getEncryptionType();
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public Date getAuthTime() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.authtime;
    }

    public InetAddress[] getClientAddresses() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        if (this.adds == null) {
            return null;
        }
        InetAddress[] inetAddressArray = new InetAddress[this.adds.size()];
        this.adds.toArray(inetAddressArray);
        return inetAddressArray;
    }

    public PrincipalName getClientName() {
        return this.cname;
    }

    public String getClientRealm() {
        return this.crealm;
    }

    Credential getCredential() throws NotYetDecryptedException {
        return new CredentialImpl(this.ticket, this.sessionKey, this.crealm, this.cname, this.srealm, this.sname, this.getClientAddresses(), this.flags, this.authtime, this.starttime, this.endtime, this.renewTill);
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public Date getEndTime() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.endtime;
    }

    public Date getKeyExpiration() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.keyExp;
    }

    public LastReqElement[] getLastRequest() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        LastReqElement[] lastReqElementArray = new LastReqElement[this.lastReq.size()];
        this.lastReq.toArray(lastReqElementArray);
        return lastReqElementArray;
    }

    int getMsgType() {
        return this.msgType;
    }

    public int getNonce() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.nonce;
    }

    public PaData[] getPadatas() {
        if (this.paDatas == null) {
            return null;
        }
        PaData[] paDataArray = new PaData[this.paDatas.size()];
        this.paDatas.toArray(paDataArray);
        return paDataArray;
    }

    public Date getRenewTill() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.renewTill;
    }

    public PrincipalName getServerName() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.sname;
    }

    public String getServerRealm() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.srealm;
    }

    public EncryptionKey getSessionKey() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.sessionKey;
    }

    public Date getStartTime() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.starttime;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketFlags getTicketFlags() throws NotYetDecryptedException {
        if (this.encKDCRepPart == null) {
            throw new NotYetDecryptedException("KDCRep not yet decrypted");
        }
        return this.flags;
    }

    public void initDecrypt(EncryptionKey encryptionKey) throws KerberosException {
        this.initDecrypt(encryptionKey, null);
    }

    public void initDecrypt(EncryptionKey encryptionKey, String string) throws KerberosException {
        if (encryptionKey == null) {
            throw new KerberosException("key is null");
        }
        int n = this.encPart.getEncryptionType();
        if (!KerberosCipher.checkEncType(n, encryptionKey.keyType())) {
            throw new KerberosException("key type mismatch");
        }
        this.cipher = KerberosCipher.getInstance(n, string);
        this.cipher.initDecrypt(encryptionKey, null);
    }

    void setAuthTime(Date date) {
        this.authtime = date;
    }

    void setClientName(PrincipalName principalName) {
        this.cname = principalName;
    }

    void setClientRealm(String string) {
        this.crealm = string;
    }

    void setEndTime(Date date) {
        this.endtime = date;
    }

    void setMsgType(int n) {
        this.msgType = n;
    }

    void setNonce(int n) {
        this.nonce = n;
    }

    void setRenewTill(Date date) {
        this.renewTill = date;
    }

    void setServerName(PrincipalName principalName) {
        this.sname = principalName;
    }

    void setServerRealm(String string) {
        this.srealm = string;
    }

    void setStartTime(Date date) {
        this.starttime = date;
    }

    void setTargetKey(EncryptionKeyImpl encryptionKeyImpl) {
        this.targetKey = encryptionKeyImpl;
    }

    void setTicketFlags(TicketFlagsImpl ticketFlagsImpl) {
        this.flags = ticketFlagsImpl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nencryption type: " + this.encryptionType());
        if (this.encKDCRepPart != null && this.decryptedOK) {
            stringBuffer.append(" (DECRYPTED OK) ");
        }
        stringBuffer.append("\nclient: " + this.getClientName() + "@" + this.getClientRealm());
        try {
            stringBuffer.append("\nservice principal: " + this.getServerName() + "@" + this.getServerRealm());
            stringBuffer.append("\nsession key: " + this.getSessionKey());
            stringBuffer.append(this.getTicket());
            stringBuffer.append("\nticket flags: " + this.getTicketFlags());
            stringBuffer.append("\nvalid from: " + this.getAuthTime());
            stringBuffer.append("\nvalid till: " + this.getEndTime());
            stringBuffer.append("\nlast request: ");
            LastReqElement[] lastReqElementArray = this.getLastRequest();
            int n = 0;
            while (n < lastReqElementArray.length) {
                stringBuffer.append(lastReqElementArray[n]);
                ++n;
            }
        }
        catch (NotYetDecryptedException notYetDecryptedException) {}
        return stringBuffer.toString();
    }
}

