/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.Token;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class PerMessageToken
extends Token {
    PerMessageToken(InputStream inputStream) throws IOException {
        try {
            int n = inputStream.read();
            if (n == -1) {
                throw new IOException("Unexpected EOF encountered");
            }
            this.readLength(inputStream);
            if (this.length != 0) {
                Oid oid = (Oid)Asn1.getAsn1(inputStream);
                this.contents = new byte[this.length - oid.getEncoded().length];
                inputStream.read(this.contents);
                this.tokenId = new byte[2];
                System.arraycopy(this.contents, 0, this.tokenId, 0, 2);
            }
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.toString());
        }
    }

    byte[] getInnerToken() {
        return this.contents;
    }

    static void write(OutputStream outputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byte[] byArray = null;
        try {
            byArray = GSSManager.KRB5.getDER();
        }
        catch (Exception exception) {}
        byte[] byArray2 = Token.toLengthOctets(byArray.length + byteArrayOutputStream.size());
        outputStream.write(96);
        outputStream.write(byArray2);
        outputStream.write(byArray);
        byteArrayOutputStream.writeTo(outputStream);
        outputStream.flush();
    }
}

