/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.keystore;

import com.dstc.security.asn1.Asn1DecodingException;
import com.dstc.security.asn1.Asn1EncodingException;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.certpath.CertPathBuilder;
import com.dstc.security.certpath.X509CertSelector;
import com.dstc.security.common.FriendlyName;
import com.dstc.security.common.X500Name;
import com.dstc.security.keymanage.PKCS8EncryptedPrivateKey;
import com.dstc.security.keymanage.PKCS8Exception;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.keystore.BagHandler;
import com.dstc.security.keymanage.keystore.Licensed;
import com.dstc.security.keymanage.keystore.NetscapeBagHandler;
import com.dstc.security.keymanage.pkcs12.AuthenticatedSafe;
import com.dstc.security.keymanage.pkcs12.InvalidFlagException;
import com.dstc.security.keymanage.pkcs12.PFX;
import com.dstc.security.keymanage.pkcs12.SafeBag;
import com.dstc.security.keymanage.pkcs12.bags.CertBag;
import com.dstc.security.keymanage.pkcs12.bags.ShroudedKeyBag;
import com.dstc.security.keymanage.util.PKCS12KeyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class P12KeyStore
extends KeyStoreSpi
implements Licensed {
    public static String DEFAULT_ENCRYPTION_ALGORITHM = "1.2.840.113549.1.12.1.3";
    private PFX pfx = null;
    private BagHandler bagHandler = null;
    private Vector tmpChainStore = new Vector();

    private void addCertEntry(String string, Certificate certificate, boolean bl, boolean bl2, boolean bl3) throws KeyStoreException {
        Object object;
        Debug.log(1, "KeyStore.setCertificateEntry()", "");
        this.isInitialized();
        this.pfx = null;
        Vector<Object> vector = new Vector<Object>();
        if (bl2) {
            vector.add(SafeBag.createFriendlyName(string));
        }
        if (bl) {
            try {
                object = certificate.getEncoded();
                vector.add(SafeBag.createLocalKeyId((byte[])object));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new KeyStoreException(certificateEncodingException.toString());
            }
        }
        object = null;
        CertBag certBag = null;
        try {
            certBag = new CertBag("1.2.840.113549.1.9.22.1", certificate);
            object = new SafeBag(certBag, vector);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Debug.log(5, "P12KeyStore.setCertificateEntry()", "Unexpected exception while creating CertBag: " + certificateEncodingException.toString());
            throw new KeyStoreException(certificateEncodingException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        if (bl2) {
            this.bagHandler.storeBag((SafeBag)object);
        } else {
            this.tmpChainStore.add(object);
            if (bl3) {
                ((NetscapeBagHandler)this.bagHandler).storeChain(string, this.tmpChainStore);
                this.tmpChainStore = new Vector();
            }
        }
        Debug.dumpAsn1To(((SafeBag)object).getAsn1(), "safebagWcertbag");
    }

    private boolean certEquals(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        return X500Name.equals(x509Certificate.getIssuerDN(), x509Certificate2.getIssuerDN()) && x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber());
    }

    private static Vector createSafeBagAttributes(String string, Certificate[] certificateArray) throws KeyStoreException {
        Vector<Object> vector = new Vector<Object>();
        try {
            vector.add(new FriendlyName(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new KeyStoreException(unsupportedEncodingException.toString());
        }
        try {
            byte[] byArray = certificateArray[0].getEncoded();
            vector.add(SafeBag.createLocalKeyId(byArray));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyStoreException(certificateEncodingException.toString());
        }
        return vector;
    }

    public Enumeration engineAliases() {
        Debug.log(1, "KeyStore.aliases()", "");
        this.isInitialized();
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.bagHandler.getAllFriendlyNames();
        int n = 0;
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        return vector.elements();
    }

    public boolean engineContainsAlias(String string) {
        Debug.log(1, "KeyStore.containsAlias( " + string + " )", "");
        this.isInitialized();
        SafeBag safeBag = this.bagHandler.getBag(string);
        return safeBag != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Debug.log(1, "KeyStore.deleteEntry()", "");
        this.isInitialized();
        this.pfx = null;
        this.bagHandler.removeBags(string);
    }

    public Certificate engineGetCertificate(String string) {
        Debug.log(1, "KeyStore.getCertificate()", "");
        this.isInitialized();
        SafeBag[] safeBagArray = this.bagHandler.getBags(string);
        CertBag certBag = null;
        int n = 0;
        while (n < safeBagArray.length) {
            try {
                certBag = (CertBag)safeBagArray[n].getBag();
                break;
            }
            catch (ClassCastException classCastException) {
                ++n;
            }
        }
        Certificate certificate = null;
        if (certBag != null) {
            certificate = certBag.getCertificate();
        } else {
            X509Certificate[] x509CertificateArray = ((NetscapeBagHandler)this.bagHandler).getChain(string);
            if (x509CertificateArray != null) {
                certificate = x509CertificateArray[0];
            }
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Debug.log(1, "KeyStore.getCertificateAlias()", "");
        this.isInitialized();
        String string = null;
        SafeBag[] safeBagArray = this.bagHandler.getAllBags();
        CertBag certBag = null;
        Certificate certificate2 = null;
        int n = 0;
        while (n < safeBagArray.length) {
            String string2;
            X509Certificate[] x509CertificateArray;
            String string3 = safeBagArray[n].getBagId();
            int n2 = string3.hashCode();
            if (n2 == SafeBag.CERTBAG) {
                certBag = (CertBag)safeBagArray[n].getBag();
                certificate2 = certBag.getCertificate();
                if (this.certEquals((X509Certificate)certificate2, (X509Certificate)certificate)) {
                    string = safeBagArray[n].getFriendlyName();
                    break;
                }
            } else if (n2 == SafeBag.SHROUDED_KEYBAG && this.certEquals((x509CertificateArray = ((NetscapeBagHandler)this.bagHandler).getChain(string2 = safeBagArray[n].getFriendlyName()))[0], (X509Certificate)certificate)) {
                string = string2;
                break;
            }
            ++n;
        }
        return string;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Debug.log(1, "KeyStore.getCertificateChain( " + string + " )", "");
        this.isInitialized();
        Vector vector = new Vector();
        Certificate[] certificateArray = ((NetscapeBagHandler)this.bagHandler).getChain(string);
        return certificateArray;
    }

    public Date engineGetCreationDate(String string) {
        Debug.log(1, "KeyStore.getCreationDate()", "");
        this.isInitialized();
        return new Date();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Debug.log(1, "KeyStoreImpl.getKey()", "");
        this.isInitialized();
        SafeBag[] safeBagArray = this.bagHandler.getBags(string);
        if (safeBagArray.length == 0) {
            throw new UnrecoverableKeyException("Key Not Present");
        }
        ShroudedKeyBag shroudedKeyBag = null;
        int n = 0;
        if (n < safeBagArray.length) {
            if (safeBagArray[n].getBagId().equals("1.2.840.113549.1.12.10.1.2")) {
                shroudedKeyBag = (ShroudedKeyBag)safeBagArray[n].getBag();
            } else {
                return null;
            }
        }
        PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = shroudedKeyBag.getEncryptedPrivateKeyInfo();
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            pKCS8EncryptedPrivateKey.decrypt(pBEKeySpec);
            return pKCS8EncryptedPrivateKey.getPrivateKey();
        }
        catch (PKCS8Exception pKCS8Exception) {
            throw new UnrecoverableKeyException(pKCS8Exception.toString());
        }
    }

    public boolean engineIsCertificateEntry(String string) {
        Debug.log(1, "KeyStore.isCertificateEntry()", "");
        this.isInitialized();
        boolean bl = false;
        SafeBag[] safeBagArray = this.bagHandler.getBags(string);
        int n = 0;
        while (n < safeBagArray.length) {
            String string2 = safeBagArray[n].getBagId();
            int n2 = string2.hashCode();
            if (n2 == SafeBag.CERTBAG) {
                bl = true;
            } else {
                if (n2 == SafeBag.KEYBAG) {
                    return false;
                }
                if (n2 == SafeBag.SHROUDED_KEYBAG) {
                    return false;
                }
            }
            ++n;
        }
        return bl;
    }

    public boolean engineIsKeyEntry(String string) {
        Debug.log(1, "KeyStore.isKeyEntry( " + string + " )", "");
        this.isInitialized();
        SafeBag[] safeBagArray = this.bagHandler.getBags(string);
        int n = 0;
        while (n < safeBagArray.length) {
            String string2 = safeBagArray[n].getBagId();
            int n2 = string2.hashCode();
            if (n2 == SafeBag.KEYBAG) {
                return true;
            }
            if (n2 == SafeBag.SHROUDED_KEYBAG) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Debug.log(1, "P12KeyStore.load()", "");
        if (inputStream == null) {
            this.bagHandler = new NetscapeBagHandler();
        } else {
            try {
                this.pfx = PFX.createPFX(inputStream);
            }
            catch (Asn1DecodingException asn1DecodingException) {
                throw new IOException(asn1DecodingException.toString());
            }
            catch (Asn1Exception asn1Exception) {
                throw new IOException(asn1Exception.toString());
            }
            SecretKey secretKey = null;
            if (cArray != null) {
                try {
                    secretKey = PKCS12KeyFactory.createPBEKey(cArray);
                    if (!this.pfx.verify(secretKey)) {
                        throw new InvalidKeyException();
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new IOException("KeyStore Integrity Compromised: " + invalidKeyException.toString());
                }
            }
            this.bagHandler = new NetscapeBagHandler();
            this.bagHandler.setPassword(cArray);
            try {
                AuthenticatedSafe authenticatedSafe = this.pfx.getAuthSafe();
                this.bagHandler.importBags(authenticatedSafe);
            }
            catch (Asn1Exception asn1Exception) {
                throw new CertificateException(asn1Exception.toString());
            }
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.addCertEntry(string, certificate, false, true, false);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        SafeBag[] safeBagArray;
        Debug.log(1, "KeyStore.setKeyEntry( Key )", "");
        this.isInitialized();
        if (certificateArray == null || certificateArray.length == 0) {
            throw new KeyStoreException("Invalid Certificate Chain");
        }
        this.verifyChain(certificateArray);
        this.pfx = null;
        Vector vector = P12KeyStore.createSafeBagAttributes(string, certificateArray);
        ShroudedKeyBag shroudedKeyBag = null;
        try {
            safeBagArray = (SafeBag[])key;
            PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey((PrivateKey)safeBagArray, DEFAULT_ENCRYPTION_ALGORITHM);
            pKCS8EncryptedPrivateKey.encrypt(cArray);
            shroudedKeyBag = new ShroudedKeyBag(pKCS8EncryptedPrivateKey);
        }
        catch (PKCS8Exception pKCS8Exception) {
            throw new KeyStoreException("Encryption error: " + pKCS8Exception.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new KeyStoreException("Not Private Key: " + classCastException.toString());
        }
        safeBagArray = new SafeBag[]{new SafeBag(shroudedKeyBag, vector)};
        this.bagHandler.storeBags(safeBagArray);
        int n = certificateArray.length - 1;
        if (n == 0) {
            this.addCertEntry(string, certificateArray[0], true, false, true);
        } else {
            this.addCertEntry(string, certificateArray[0], true, false, false);
        }
        int n2 = 1;
        while (n2 < n) {
            this.addCertEntry(string, certificateArray[n2], false, false, false);
            ++n2;
        }
        if (n > 0) {
            this.addCertEntry(string, certificateArray[n], false, false, true);
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Debug.log(1, "KeyStore.setKeyEntry( byte[] )", "");
        this.pfx = null;
        if (certificateArray == null || certificateArray.length == 0) {
            throw new KeyStoreException("Invalid Certificate Chain");
        }
        this.verifyChain(certificateArray);
        PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = null;
        try {
            pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(byArray);
        }
        catch (PKCS8Exception pKCS8Exception) {
            throw new KeyStoreException("Invalid Encrypted Private Key: " + pKCS8Exception.toString());
        }
        ShroudedKeyBag shroudedKeyBag = new ShroudedKeyBag(pKCS8EncryptedPrivateKey);
        Vector vector = P12KeyStore.createSafeBagAttributes(string, certificateArray);
        SafeBag safeBag = new SafeBag(shroudedKeyBag, vector);
        this.bagHandler.storeBag(safeBag);
        int n = certificateArray.length - 1;
        if (n == 0) {
            this.addCertEntry(string, certificateArray[0], true, false, true);
        } else {
            this.addCertEntry(string, certificateArray[0], true, false, false);
        }
        int n2 = 1;
        while (n2 < n) {
            this.addCertEntry(string, certificateArray[n2], false, false, false);
            ++n2;
        }
        if (n > 0) {
            this.addCertEntry(string, certificateArray[n], false, false, true);
        }
    }

    public int engineSize() {
        Debug.log(1, "KeyStore.size()", "");
        this.isInitialized();
        return this.bagHandler.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Debug.log(1, "KeyStoreImpl.store()", "");
        this.isInitialized();
        if (this.pfx == null) {
            AuthenticatedSafe authenticatedSafe = this.bagHandler.export();
            this.pfx = new PFX(authenticatedSafe);
            try {
                SecretKey secretKey = PKCS12KeyFactory.createPBEKey(cArray);
                PBEParameterSpec pBEParameterSpec = PKCS12KeyFactory.generatePBEParameterSpec();
                this.pfx.mac(secretKey, pBEParameterSpec, 1);
            }
            catch (InvalidFlagException invalidFlagException) {
                throw new IOException("Internal Error While Creating PBEKey: " + invalidFlagException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException("Exception While Creating PBEKey: " + invalidKeyException.toString());
            }
        }
        try {
            this.pfx.encode(outputStream);
        }
        catch (Asn1EncodingException asn1EncodingException) {
            throw new IOException("Exception while encoding PFX to ASN.1: " + asn1EncodingException.toString());
        }
    }

    private String getCN(X509Certificate x509Certificate) {
        Principal principal = x509Certificate.getSubjectDN();
        String string = principal.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.indexOf("CN") != -1) {
                string2 = string4;
                continue;
            }
            if (string4.indexOf("OU") == -1) continue;
            string3 = string4;
        }
        if (string2 != null) {
            int n = string2.indexOf("=");
            return string2.substring(n + 1);
        }
        if (string3 != null) {
            int n = string3.indexOf("=");
            return string3.substring(n + 1);
        }
        return string;
    }

    private void isInitialized() {
        if (this.bagHandler == null) {
            throw new RuntimeException("Operation On Uninitialized KeyStore");
        }
    }

    private void verifyChain(Certificate[] certificateArray) throws KeyStoreException {
        try {
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            X509CertSelector x509CertSelector = new X509CertSelector();
            CertPathBuilder certPathBuilder = new CertPathBuilder();
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            int n = 0;
            while (n < x509CertificateArray.length) {
                x509CertificateArray[n] = (X509Certificate)certificateArray[n];
                ++n;
            }
            vector.add(x509CertificateArray[x509CertificateArray.length - 1]);
            certPathBuilder.setTrustedCerts(vector);
            x509CertSelector.setIssuerDN(x509Certificate.getIssuerDN().getName());
            x509CertSelector.setSerialNumber(x509Certificate.getSerialNumber());
            certPathBuilder.verify(x509CertificateArray);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cert chain doesn't verify: " + exception.getMessage());
        }
    }
}

