/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12.bags;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs12.bags.Bag;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CertBag
implements Bag {
    public static final String X509_CERTIFICATE = "1.2.840.113549.1.9.22.1";
    public static final String SDSI_CERTIFICATE = "1.2.840.113549.1.9.22.2";
    private static final int X509 = "1.2.840.113549.1.9.22.1".hashCode();
    private static final int SDSI = "1.2.840.113549.1.9.22.2".hashCode();
    private static final String KEYBAG_OID = "1.2.840.113549.1.12.10.1.3";
    private static final int TAG_EXPLICIT = 0;
    private Asn1 asn1;
    private String certId;
    private Certificate certificate;

    public CertBag(Asn1 asn1) throws Asn1Exception {
        Debug.dumpAsn1To(asn1, "certbag");
        this.asn1 = asn1;
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new RuntimeException("No certificate factory for X.509");
        }
        try {
            Iterator iterator = this.asn1.components();
            Oid oid = (Oid)iterator.next();
            this.certId = oid.getOid();
            Asn1 asn12 = (Asn1)iterator.next();
            Iterator iterator2 = asn12.components();
            int n = oid.getOid().hashCode();
            if (X509 != n) {
                if (SDSI == n) {
                    IA5String iA5String = (IA5String)iterator2.next();
                    Debug.log(2, "CertBag( Asn1 )", "SDSI Certificates Unsupported");
                    throw new Asn1Exception("SDSI Certificates Are Yet To Be Supported");
                }
                throw new Asn1Exception("Unknown Certificate Type");
            }
            OctetString octetString = (OctetString)iterator2.next();
            byte[] byArray = octetString.getBytes();
            Asn1 asn13 = Asn1.getAsn1(byArray);
            Debug.dumpAsn1To(asn13, "cert");
            this.certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Invalid CertBag ASN.1");
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid CertBag ASN.1");
        }
        catch (CertificateException certificateException) {
            throw new Asn1Exception("Invalid X509Certificate");
        }
    }

    public CertBag(String string, Certificate certificate) throws CertificateException {
        this.certId = string;
        this.certificate = certificate;
        this.initialize();
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getCertId() {
        return this.certId;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public String getType() {
        return KEYBAG_OID;
    }

    private void initialize() throws CertificateException {
        this.asn1 = new Sequence();
        Oid oid = new Oid(this.certId);
        this.asn1.add(oid);
        Explicit explicit = new Explicit(128, 0);
        X509Certificate x509Certificate = null;
        int n = this.certId.hashCode();
        if (X509 == n) {
            try {
                x509Certificate = (X509Certificate)this.certificate;
            }
            catch (ClassCastException classCastException) {
                Debug.log(2, "CertBag.initialize()", "X509Certificate expected; received: " + x509Certificate.getType());
                throw new CertificateException("X509Certificate expected; received: " + x509Certificate.getType());
            }
        } else {
            if (SDSI == n) {
                throw new CertificateException("SDSI Certificates Are Yet To Be Supported");
            }
            throw new CertificateException("Unknown Certificate Type");
        }
        byte[] byArray = x509Certificate.getEncoded();
        OctetString octetString = new OctetString(byArray);
        explicit.add(octetString);
        this.asn1.add(explicit);
    }
}

